package com.ejianc.business.dxcheck.controller;/*author Wyx*/

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.dxcheck.entity.UserEntity;
import com.ejianc.business.dxcheck.model.vo.UserVO;
import com.ejianc.business.dxcheck.service.UserService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author wyx
 * 单位用户配置
 */
@Controller
@RequestMapping("user")
public class UserController implements Serializable {
    @Autowired
    private UserService service;
    @Autowired
    private IOrgApi iOrgApi;

    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<UserVO>> queryList(@RequestBody QueryParam param) {
        /**模糊搜索配置字段示例*/
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("assessmentUnitName");
        fuzzyFields.add("assessorName");
        fuzzyFields.add("leaderProjectManagementName");
        fuzzyFields.add("leaderUnitResponseName");
        fuzzyFields.add("leaderInfoDepartmentName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<UserEntity> page = service.queryPage(param, false);
        IPage<UserVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), UserVO.class));
        return CommonResponse.success("查询列表数据成功", pageData);
    }

    /**
     * 查询详情
     *
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<UserVO> queryDetail(Long id) {
        UserEntity entity = service.selectById(id);
        UserVO vo = BeanMapper.map(entity, UserVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<UserVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (UserVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(UserVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<UserVO> saveOrUpdate(@RequestBody UserVO saveOrUpdateVO) {
        System.out.println("打印时间" + saveOrUpdateVO.getModifyTime());
        UserEntity entity = BeanMapper.map(saveOrUpdateVO, UserEntity.class);

        List<UserEntity> list = service.lambdaQuery().eq(UserEntity::getAssessmentUnitId, entity.getAssessmentUnitId())
                .eq(UserEntity::getYear, entity.getYear())
                .list();
        if (!list.isEmpty()) {
            throw new BusinessException("该单位此年份已存在配置");
        }
        service.saveOrUpdate(entity, false);
        UserVO vo = BeanMapper.map(entity, UserVO.class);
        return CommonResponse.success("保存或者修改单据成功", vo);
    }

    /**
     * 通过组织分类来查询所分类的组织
     * 组织分类包括(中国能源建设集团浙江火电建设有限公司本部；浙江火电直管项目；浙江火电分公司；浙江火电子公司)
     */

    @RequestMapping(value = "/queryOrg", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OrgVO>> queryOrg(@RequestBody QueryParam param) {
        String orgType = param.getSearchText().split(",")[0];
        IPage<OrgVO> page = service.OrgTree(param, Integer.parseInt(orgType));
        return CommonResponse.success("获取组织成功", page);
    }

    @RequestMapping(value = "/refUserData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<UserVO>> refProTeamData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                        String condition,
                                                        String searchObject,
                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /**模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            Map<String, String> conditionmap = JSONObject.parseObject(condition, Map.class);
            if (null == conditionmap.get("createTime")) {
                return CommonResponse.error("查询失败，参数condition中缺少createTime");
            }
            LinkedHashMap<String, String> ordermap = new LinkedHashMap<>(conditionmap);
            param.setOrderMap(ordermap);
        }
        IPage<UserEntity> page = service.queryPage(param, false);
        IPage<UserVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), UserVO.class));

        return CommonResponse.success("查询参照数据成功", pageData);
    }
}
