package com.ejianc.business.dxcheck.dao.impl;

import com.ejianc.business.dxcheck.dao.RecordDao;
import com.ejianc.business.dxcheck.dao.RecordSubDao;
import com.ejianc.business.dxcheck.entity.RecordEntity;
import com.ejianc.business.dxcheck.entity.RecordSubEntity;
import com.ejianc.business.dxcheck.mapper.RecordMapper;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @Author: LCL
 * @Date: 2024/5/28 上午9:58
 */
@Service
@Slf4j
@RequiredArgsConstructor
public class RecordDaoImpl extends BaseServiceImpl<RecordMapper, RecordEntity> implements RecordDao {
    private final RecordSubDao subDao;

    @Override
    public void synchronizationState(Long id, int state) {
        lambdaUpdate().eq(BaseEntity::getId, id).set(RecordEntity::getState, state).update();
        subDao.lambdaUpdate().eq(RecordSubEntity::getRecordId, id).set(RecordSubEntity::getState, state).update();
    }
}
