package com.ejianc.business.dxcheck.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.sql.Date;

/**
 * @Author: LCL
 * @Date: 2024/5/28 上午9:53
 * @Description: 考评组人员
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
@TableName("ejc_dxcheck_team")
public class TeamEntity extends BaseEntity {
    /**
     * 序号
     */
    @TableField(value = "serial_num")
    private Integer serialNum;

    /**
     * 考核单/部门code
     */
    @TableField(value = "assessment_unit_code")
    private String assessmentUnitCode;

    /**
     * 考核单位/部门名称
     */
    @TableField(value = "assessment_unit_name")
    private String assessmentUnitName;

    /**
     * 考核人员工号
     */
    @TableField(value = "assessor_job_num")
    private String assessorJobNum;

    /**
     * 考核人员
     */
    @TableField(value = "assessor_name")
    private String assessorName;

    /**
     * 信息化部门领导工号
     */
    @TableField(value = "leader_info_department_num")
    private String leaderInfoDepartmentNum;

    /**
     * 信息化部门领导
     */
    @TableField(value = "leader_info_department_name")
    private String leaderInfoDepartmentName;

    /**
     * 项目分管领导工号
     */
    @TableField(value = "leader_project_management_num")
    private String leaderProjectManagementNum;

    /**
     * 项目分管领导
     */
    @TableField(value = "leader_project_management_name")
    private String leaderProjectManagementName;

    /**
     * 单位负责人领导工号
     */
    @TableField(value = "leader_unit_response_num")
    private String leaderUnitResponseNum;

    /**
     * 单位负责领导
     */
    @TableField(value = "leader_unit_response_name")
    private String leaderUnitResponseName;

    /**
     * 修改人工号
     */
    @TableField(value = "modifier_job_num")
    private String modifierJobNum;

    /**
     * 修改人
     */
    @TableField(value = "modifier_name")
    private String modifierName;

    /**
     * 修改人修改时间
     */
    @TableField(value = "modify_time")
    private Date modifyTime;

    /**
     * 组类型(1.考评组 2.专业组)
     */
    @TableField(value = "team_type")
    private int teamType;

    /**
     * 组名称
     */
    @TableField(value = "team_name")
    private String teamName;

    /**
     * 描述
     */
    @TableField(value = "team_describe")
    private String teamDescribe;
}
