package com.ejianc.business.dxcheck.mapper;

import com.ejianc.business.dxcheck.entity.UserEntity;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;
import java.util.Map;

/**
 * @Author: LCL
 * @Date: 2024/4/10 10:07
 */
@Mapper
public interface UserMapper extends BaseCrudMapper<UserEntity> {
    @Select("SELECT a.org_type as orgType, COUNT(*) as count " +
            "FROM ejc_dxcheck_user a " +
            "INNER JOIN ejc_dxcheck_user b ON a.org_type = b.org_type " +
            "WHERE a.assessment_unit_code = #{assessmentUnitCode} " +
            "GROUP BY a.org_type ")
    List<Map<String, Object>> getOrgTypeInfoByUnitCode(@Param("assessmentUnitCode") String assessmentUnitCode);
}
