package com.ejianc.business.dxcheck.model.res;

import com.ejianc.business.dxcheck.entity.NormEntity;
import com.ejianc.business.dxcheck.entity.RecordSubEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.List;


/**
 * @Author: LCL
 * @Date: 2024/6/5 上午9:23
 * @Description: 考核记录统计返回
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class RecordStatisticsRes {
    /**
     * 第一季度加减分
     */
    private BigDecimal q1;
    /**
     * 第二季度加减分
     */
    private BigDecimal q2;
    /**
     * 第三季度加减分
     */
    private BigDecimal q3;
    /**
     * 第四季度加减分
     */
    private BigDecimal q4;
    /**
     * 当年加减分
     */
    private BigDecimal yearScore;
    /**
     * 年度总分
     */
    private BigDecimal totalAnnualScore;
    /**
     * 板块平均得分
     */
    private BigDecimal plateAverageScore;
    /**
     * 排名
     */
    private Integer rank;
    /**
     * 总数
     */
    private Integer total;

    private List<NormRes> normResList;

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class NormRes extends NormEntity {
        /**
         * 考核记录情况
         */
        private List<RecordSubStatisticsRes> recordSubList;
        /**
         * 当年加扣
         */
        private BigDecimal deductionYear;
        /**
         * 加扣比例
         */
        private String deductionRate;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class RecordSubStatisticsRes extends RecordSubEntity {
        /**
         * 当年加扣
         */
        private BigDecimal deductionYear;
        /**
         * 加扣比例
         */
        private String deductionRate;
        /**
         * 是否高亮
         */
        private Boolean isH;
    }
}
