package com.ejianc.business.dxcheck.service;


import com.ejianc.business.dxcheck.entity.NormEntity;
import com.ejianc.business.dxcheck.model.vo.NormAddVo;
import com.ejianc.business.dxcheck.model.vo.NormEditVo;
import com.ejianc.framework.core.response.CommonResponse;

import java.util.List;
import java.util.Map;

/**
 * @Author: LCL
 * @Date: 2024/5/28 下午2:17
 * @Description: 考核指标
 */
public interface NormServer {
    /**
     * 新增
     *
     * @param vo vo
     * @return NormEntity
     */
    CommonResponse<NormEntity> add(NormAddVo vo);

    /**
     * 删除
     *
     * @param ids ids
     */
    void del(List<Long> ids);

    /**
     * 详情
     *
     * @param id id
     * @return NormEntity
     */
    NormEntity detail(Long id);

    /**
     * 列表
     *
     * @return 列表
     */
    Map<String, Map<String, List<NormEntity>>> list();

    /**
     * 修改
     * @param vo NormEditVo
     * @return 结果
     */
    NormEntity edit(NormEditVo vo);

    /**
     * 上移 下移
     * @param id id
     * @param move 上移up  下移down
     * @return 结果
     */
    CommonResponse<String> move(Long id, String move);
}
