/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.dxcheck.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.additional.query.impl.LambdaQueryChainWrapper;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.dxcheck.dao.NormDao;
import com.ejianc.business.dxcheck.dao.RecordDao;
import com.ejianc.business.dxcheck.dao.RecordSubDao;
import com.ejianc.business.dxcheck.dao.TeamUserDao;
import com.ejianc.business.dxcheck.dao.UserDao;
import com.ejianc.business.dxcheck.entity.NormEntity;
import com.ejianc.business.dxcheck.entity.RecordEntity;
import com.ejianc.business.dxcheck.entity.RecordSubEntity;
import com.ejianc.business.dxcheck.entity.TeamUserEntity;
import com.ejianc.business.dxcheck.entity.UserEntity;
import com.ejianc.business.dxcheck.enums.OrgTypeEnums;
import com.ejianc.business.dxcheck.model.res.AssessmentRankRes;
import com.ejianc.business.dxcheck.model.res.RecordStatisticsRes;
import com.ejianc.business.dxcheck.service.StatisticsServer;
import com.ejianc.business.dxcheck.util.DateExtUtil;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class StatisticsServerImpl
implements StatisticsServer {
    private static final Logger log = LoggerFactory.getLogger(StatisticsServerImpl.class);
    private final RecordDao recordDao;
    private final RecordSubDao recordSubDao;
    private final UserDao userDao;
    private final NormDao normDao;
    private final TeamUserDao teamUserDao;
    private final SessionManager sessionManager;
    @Qualifier(value="com.ejianc.foundation.permission.api.IRoleApi")
    private final IRoleApi iRoleApi;

    @Override
    public JSONArray getTree() {
        List userEntities = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.userDao.lambdaQuery().select(new SFunction[]{UserEntity::getOrgType, UserEntity::getAssessmentUnitName, UserEntity::getAssessmentUnitCode}).eq(UserEntity::getStatus, (Object)"\u542f\u7528")).groupBy((Object[])new SFunction[]{UserEntity::getOrgType, UserEntity::getAssessmentUnitCode})).list();
        return this.buildTree(userEntities);
    }

    @Override
    public AssessmentRankRes assessmentRank(String year) {
        Pair<DateTime, DateTime> yearStartEndTime = DateExtUtil.getYearStartEndTime(year);
        List userEntities = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.userDao.lambdaQuery().select(new SFunction[]{UserEntity::getOrgType, UserEntity::getAssessmentUnitName, UserEntity::getAssessmentUnitShortName, UserEntity::getAssessmentUnitCode}).eq(UserEntity::getStatus, (Object)"\u542f\u7528")).between(BaseEntity::getCreateTime, yearStartEndTime.getLeft(), yearStartEndTime.getRight())).groupBy((Object[])new SFunction[]{UserEntity::getOrgType, UserEntity::getAssessmentUnitCode})).list();
        List nowYearList = ((LambdaQueryChainWrapper)this.recordSubDao.lambdaQuery().between(BaseEntity::getCreateTime, yearStartEndTime.getLeft(), yearStartEndTime.getRight())).list();
        List<UserEntity> bbList = userEntities.stream().filter(e -> e.getOrgType() == 1).collect(Collectors.toList());
        List<RecordSubEntity> bbYearList = nowYearList.stream().filter(e -> e.getOrgType() == 1).collect(Collectors.toList());
        List<AssessmentRankRes.AssessmentRankInfo> bbInfoList = this.disposeScores(bbList, bbYearList, year);
        List<UserEntity> zgxmList = userEntities.stream().filter(e -> e.getOrgType() == 2).collect(Collectors.toList());
        List<RecordSubEntity> zgxmYearList = nowYearList.stream().filter(e -> e.getOrgType() == 2).collect(Collectors.toList());
        List<AssessmentRankRes.AssessmentRankInfo> zgxmInfoList = this.disposeScores(zgxmList, zgxmYearList, year);
        List<UserEntity> fzgList = userEntities.stream().filter(e -> e.getOrgType() == 3).collect(Collectors.toList());
        List<RecordSubEntity> fzgsYearList = nowYearList.stream().filter(e -> e.getOrgType() == 3).collect(Collectors.toList());
        List<AssessmentRankRes.AssessmentRankInfo> fzgsInfoList = this.disposeScores(fzgList, fzgsYearList, year);
        return AssessmentRankRes.builder().bb(bbInfoList).zgxm(zgxmInfoList).fzgs(fzgsInfoList).build();
    }

    @Override
    public JSONArray record(String unitCode, String year) {
        JSONArray res = JSONUtil.createArray();
        JSONObject other = JSONUtil.createObj();
        if (StrUtil.isBlank((CharSequence)unitCode) || "null".equals(unitCode)) {
            return res;
        }
        Pair<DateTime, DateTime> yearStartEndTime = DateExtUtil.getYearStartEndTime(year);
        List<Map<String, Object>> orgTypeInfoByUnitCode = this.userDao.getOrgTypeInfoByUnitCode(unitCode);
        Integer orgType = !orgTypeInfoByUnitCode.isEmpty() ? (Integer)orgTypeInfoByUnitCode.get(0).get("orgType") : 1;
        List orgTypeRecordSubList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.recordSubDao.lambdaQuery().eq(RecordSubEntity::getOrgType, (Object)orgType)).between(BaseEntity::getCreateTime, yearStartEndTime.getLeft(), yearStartEndTime.getRight())).list();
        BigDecimal plateScore = orgTypeRecordSubList.stream().map(record -> record.getFinalScore() != null ? record.getFinalScore() : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add);
        Long plateSize = orgTypeInfoByUnitCode.isEmpty() ? 0L : (Long)orgTypeInfoByUnitCode.get(0).get("count");
        BigDecimal plateSum = plateScore.add(BigDecimal.valueOf(plateSize * 100L));
        BigDecimal plateAverageScore = plateSum.divide(plateSize.equals(NumberUtils.LONG_ZERO) ? BigDecimal.ONE : BigDecimal.valueOf(plateSize), 2, RoundingMode.HALF_UP);
        int rank = orgTypeRecordSubList.stream().collect(Collectors.groupingBy(RecordSubEntity::getAssessmentUnitCode, Collectors.reducing(BigDecimal.ZERO, record -> record.getFinalScore() != null ? record.getFinalScore() : BigDecimal.ZERO, BigDecimal::add))).entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).map(Map.Entry::getKey).collect(Collectors.toList()).indexOf(unitCode) + 1;
        List recordSubEntityList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.recordSubDao.lambdaQuery().eq(RecordSubEntity::getAssessmentUnitCode, (Object)unitCode)).between(BaseEntity::getCreateTime, yearStartEndTime.getLeft(), yearStartEndTime.getRight())).list();
        int size = (int)recordSubEntityList.stream().filter(e -> e.getFinalScore() == null).count();
        BigDecimal yearScore = recordSubEntityList.stream().map(record -> record.getFinalScore() != null ? record.getFinalScore() : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalAnnualScore = NumberUtil.add((Number)yearScore, (Number)100);
        DateExtUtil.QuarterStartEndTime quarterStartEndTime = DateExtUtil.getQuarterStartEndTime(year);
        BigDecimal q1 = recordSubEntityList.stream().filter(e -> e.getCreateTime().after((Date)quarterStartEndTime.getQ1StartTime()) && e.getCreateTime().before((Date)quarterStartEndTime.getQ1EndTime())).map(record -> record.getFinalScore() != null ? record.getFinalScore() : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        BigDecimal q2 = recordSubEntityList.stream().filter(e -> e.getCreateTime().after((Date)quarterStartEndTime.getQ2StartTime()) && e.getCreateTime().before((Date)quarterStartEndTime.getQ2EndTime())).map(record -> record.getFinalScore() != null ? record.getFinalScore() : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        BigDecimal q3 = recordSubEntityList.stream().filter(e -> e.getCreateTime().after((Date)quarterStartEndTime.getQ3StartTime()) && e.getCreateTime().before((Date)quarterStartEndTime.getQ3EndTime())).map(record -> record.getFinalScore() != null ? record.getFinalScore() : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        BigDecimal q4 = recordSubEntityList.stream().filter(e -> e.getCreateTime().after((Date)quarterStartEndTime.getQ4StartTime()) && e.getCreateTime().before((Date)quarterStartEndTime.getQ4EndTime())).map(record -> record.getFinalScore() != null ? record.getFinalScore() : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        other.put("q1", (Object)q1);
        other.put("q2", (Object)q2);
        other.put("q3", (Object)q3);
        other.put("q4", (Object)q4);
        other.put("yearScore", (Object)yearScore);
        other.put("totalAnnualScore", (Object)totalAnnualScore);
        other.put("plateAverageScore", (Object)plateAverageScore);
        other.put("rank", (Object)rank);
        other.put("total", (Object)Math.toIntExact(plateSize));
        if (size == recordSubEntityList.size()) {
            other.put("rank", null);
        }
        List<NormEntity> normList = this.normDao.getFirstSecondListOrder();
        Map<String, Map<String, List<NormEntity>>> collect1 = normList.stream().collect(Collectors.groupingBy(NormEntity::getFirstClassify, Collectors.groupingBy(NormEntity::getSecondClassify)));
        List firstSet = normList.stream().map(NormEntity::getFirstClassify).distinct().collect(Collectors.toList());
        JSONArray normArray = JSONUtil.createArray();
        String userCode = String.valueOf(this.sessionManager.getUserContext().getUserCode());
        Map<Long, List<RecordSubEntity>> normIdAndSubListMap = recordSubEntityList.stream().filter(e -> e.getNormId() != null).collect(Collectors.groupingBy(RecordSubEntity::getNormId));
        for (String first : firstSet) {
            JSONObject firstNode = JSONUtil.createObj();
            firstNode.put("id", (Object)RandomUtil.randomString((int)7));
            firstNode.put("key", (Object)first);
            firstNode.put("normContent", (Object)first);
            Map<String, List<NormEntity>> stringListMap = collect1.get(first);
            JSONArray childrenArray = JSONUtil.createArray();
            Set<String> secondSet = stringListMap.keySet();
            for (String second : secondSet) {
                JSONObject secondNode = JSONUtil.createObj();
                secondNode.put("id", (Object)RandomUtil.randomString((int)7));
                secondNode.put("key", (Object)second);
                secondNode.put("normContent", (Object)second);
                if (stringListMap.containsKey(second)) {
                    List<NormEntity> secondList = stringListMap.get(second);
                    List normRes = BeanMapper.mapList(secondList, RecordStatisticsRes.NormRes.class);
                    for (RecordStatisticsRes.NormRes normRes1 : normRes) {
                        BigDecimal deductionRate;
                        Long normId = normRes1.getId();
                        List recordSubList = Lists.newArrayList();
                        normRes1.setRecordSubList(recordSubList);
                        if (!normIdAndSubListMap.containsKey(normId)) continue;
                        List<RecordSubEntity> subList = normIdAndSubListMap.get(normId);
                        subList.forEach(e -> {
                            RecordStatisticsRes.RecordSubStatisticsRes recordSubStatisticsRes = new RecordStatisticsRes.RecordSubStatisticsRes();
                            BeanUtils.copyProperties((Object)e, (Object)((Object)recordSubStatisticsRes));
                            recordSubList.add(recordSubStatisticsRes);
                        });
                        BigDecimal deductionYear = subList.stream().map(record -> record.getFinalScore() != null ? record.getFinalScore() : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add);
                        normRes1.setDeductionYear(deductionYear);
                        BigDecimal reduceLimit = NumberUtil.toBigDecimal((String)((RecordStatisticsRes.RecordSubStatisticsRes)((Object)recordSubList.get(0))).getReduceLimit());
                        BigDecimal plusLimit = NumberUtil.toBigDecimal((String)((RecordStatisticsRes.RecordSubStatisticsRes)((Object)recordSubList.get(0))).getPlusLimit());
                        BigDecimal dividend = NumberUtil.sub((Number)plusLimit, (Number)reduceLimit);
                        if (dividend.compareTo(BigDecimal.ZERO) == 0) {
                            deductionRate = BigDecimal.ZERO;
                            normRes1.setDeductionRate(deductionRate + "%");
                        } else {
                            deductionRate = NumberUtil.div((Number)NumberUtil.sub((Number)deductionYear, (Number)reduceLimit), (Number)dividend).multiply(BigDecimal.valueOf(100L)).setScale(2, RoundingMode.HALF_UP);
                            normRes1.setDeductionRate(deductionRate + "%");
                        }
                        recordSubList.forEach(e -> {
                            List list;
                            e.setDeductionYear(deductionYear);
                            e.setDeductionRate(deductionRate + "%");
                            e.setIsH(false);
                            if (StrUtil.isNotEmpty((CharSequence)e.getApproveUserCode()) && (list = JSONUtil.toList((JSONArray)JSONUtil.parseArray((String)e.getApproveUserCode()), String.class)).contains(userCode)) {
                                e.setIsH(true);
                            }
                        });
                        normRes1.setRecordSubList(recordSubList);
                    }
                    secondNode.put("children", (Object)normRes);
                }
                childrenArray.add((Object)secondNode);
            }
            firstNode.put("children", (Object)childrenArray);
            normArray.put((Object)firstNode);
        }
        res.add((Object)normArray);
        res.add((Object)other);
        return res;
    }

    @Override
    public JSONArray tips(String year) {
        Pair<DateTime, DateTime> yearStartEndTime = DateExtUtil.getYearStartEndTime(year);
        JSONArray jsonArray = JSONUtil.createArray();
        JSONObject node = JSONUtil.createObj();
        Long deptId = this.sessionManager.getUserContext().getDeptId();
        String userCode = this.sessionManager.getUserContext().getUserCode();
        Long userId = this.sessionManager.getUserContext().getUserId();
        List agent = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.recordSubDao.lambdaQuery().like(RecordSubEntity::getApproveUserCode, (Object)userCode)).between(BaseEntity::getCreateTime, yearStartEndTime.getLeft(), yearStartEndTime.getRight())).list();
        node.put("agent", (Object)agent.size());
        if (!agent.isEmpty()) {
            int count = 0;
            for (RecordSubEntity recordSubEntity : agent) {
                if (deptId == null || recordSubEntity.getAssessmentUnitId().equals(String.valueOf(deptId))) continue;
                ++count;
            }
            node.put("unit", (Object)count);
        }
        List comingAgent = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.recordDao.lambdaQuery().like(RecordEntity::getProfessionalGroupMembers, (Object)userId)).between(BaseEntity::getCreateTime, yearStartEndTime.getLeft(), yearStartEndTime.getRight())).or()).like(RecordEntity::getEvaluationGroupMembers, (Object)userId)).between(BaseEntity::getCreateTime, yearStartEndTime.getLeft(), yearStartEndTime.getRight())).list();
        node.put("comingAgent", (Object)comingAgent.size());
        jsonArray.put((Object)node);
        List<Long> roleIdList = this.iRoleApi.toString().contains("test.ztpc.com") ? Collections.singletonList(856893004038828089L) : Collections.singletonList(860556490367316055L);
        try {
            CommonResponse roleUser = this.iRoleApi.getRoleUser(roleIdList, null);
            Set teamLeaderIdSet = ((List)roleUser.getData()).stream().map(RoleUserRelationVO::getUserId).collect(Collectors.toSet());
            List<TeamUserEntity> allInfoListByTeamType = this.teamUserDao.getAllInfoListByTeamType(1);
            Set teamUserIdSet = allInfoListByTeamType.stream().map(TeamUserEntity::getTeamUserId).collect(Collectors.toSet());
            if (teamUserIdSet.contains(userId) || teamLeaderIdSet.contains(userId)) {
                node.put("isView", (Object)true);
            } else {
                node.put("isView", (Object)false);
            }
            jsonArray.put((Object)node);
            return jsonArray;
        }
        catch (Exception e) {
            return jsonArray;
        }
    }

    @Override
    public JSONArray getNewRecord() {
        JSONArray jsonArray = JSONUtil.createArray();
        JSONObject node = JSONUtil.createObj();
        List recordSubEntityList = ((LambdaQueryChainWrapper)this.recordSubDao.lambdaQuery().isNotNull(RecordSubEntity::getFinalScore)).list();
        List addList = recordSubEntityList.stream().filter(e -> e.getFinalScore().compareTo(BigDecimal.ZERO) >= 0).sorted(Comparator.comparing(RecordSubEntity::getFinalScore).reversed()).collect(Collectors.toList());
        addList.subList(0, Math.min(addList.size(), 4));
        List subtractList = recordSubEntityList.stream().filter(e -> e.getFinalScore().compareTo(BigDecimal.ZERO) < 0).sorted(Comparator.comparing(RecordSubEntity::getFinalScore).reversed()).collect(Collectors.toList());
        subtractList.subList(0, Math.min(addList.size(), 4));
        node.put("add", addList);
        node.put("subtract", subtractList);
        recordSubEntityList.sort(Comparator.comparing(BaseEntity::getCreateTime).reversed());
        node.put("all", (Object)recordSubEntityList);
        jsonArray.put((Object)node);
        return jsonArray;
    }

    private JSONArray buildTree(List<UserEntity> list) {
        String deptId = String.valueOf(this.sessionManager.getUserContext().getDeptId());
        Map<Integer, List<UserEntity>> orgTypeAndUnitInfoListMap = list.stream().collect(Collectors.groupingBy(UserEntity::getOrgType));
        JSONArray jsonArray = JSONUtil.createArray();
        for (Map.Entry<Integer, List<UserEntity>> orgTypeAndUnitInfoList : orgTypeAndUnitInfoListMap.entrySet()) {
            Integer orgType = orgTypeAndUnitInfoList.getKey();
            JSONObject node = JSONUtil.createObj();
            node.put("title", (Object)OrgTypeEnums.getNameByCode(orgType));
            node.put("key", (Object)orgType);
            List<UserEntity> unitInfoList = orgTypeAndUnitInfoList.getValue();
            JSONArray childrenArray = JSONUtil.createArray();
            for (UserEntity userEntity : unitInfoList) {
                JSONObject childNode = JSONUtil.createObj();
                childNode.put("title", (Object)userEntity.getAssessmentUnitName());
                childNode.put("key", (Object)userEntity.getAssessmentUnitCode());
                if (userEntity.getAssessmentUnitCode().equals(deptId)) {
                    childNode.put("isH", (Object)true);
                } else {
                    childNode.put("isH", (Object)false);
                }
                childrenArray.add((Object)childNode);
            }
            node.put("children", (Object)childrenArray);
            jsonArray.add((Object)node);
        }
        return jsonArray;
    }

    private List<AssessmentRankRes.AssessmentRankInfo> disposeScores(List<UserEntity> userList, List<RecordSubEntity> recordSubList, String year) {
        List infoList = Lists.newArrayList();
        Map<String, List<RecordSubEntity>> unitRecordSubMap = recordSubList.stream().collect(Collectors.groupingBy(RecordSubEntity::getAssessmentUnitCode));
        for (UserEntity userEntity : userList) {
            String assessmentUnitCode = userEntity.getAssessmentUnitCode();
            String assessmentUnitName = userEntity.getAssessmentUnitName();
            String assessmentUnitShortName = userEntity.getAssessmentUnitShortName();
            AssessmentRankRes.AssessmentRankInfo res = AssessmentRankRes.AssessmentRankInfo.builder().unitCode(assessmentUnitCode).unitName(assessmentUnitName).unitShortName(assessmentUnitShortName).build();
            if (!unitRecordSubMap.containsKey(assessmentUnitCode)) {
                res.setQ1(BigDecimal.ZERO);
                res.setQ2(BigDecimal.ZERO);
                res.setQ3(BigDecimal.ZERO);
                res.setQ4(BigDecimal.ZERO);
                res.setYearScore(BigDecimal.ZERO);
                res.setTotalAnnualScore(BigDecimal.valueOf(100L));
                infoList.add(res);
                continue;
            }
            List<RecordSubEntity> recordSubEntityList = unitRecordSubMap.get(assessmentUnitCode);
            BigDecimal totalAnnualScore = BigDecimal.valueOf(100L);
            BigDecimal yearScore = recordSubEntityList.stream().map(record -> record.getFinalScore() != null ? record.getFinalScore() : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
            totalAnnualScore = totalAnnualScore.add(yearScore).setScale(2, RoundingMode.HALF_UP);
            DateExtUtil.QuarterStartEndTime quarterStartEndTime = DateExtUtil.getQuarterStartEndTime(year);
            BigDecimal q1 = recordSubEntityList.stream().filter(e -> e.getCreateTime().after((Date)quarterStartEndTime.getQ1StartTime()) && e.getCreateTime().before((Date)quarterStartEndTime.getQ1EndTime())).map(record -> record.getFinalScore() != null ? record.getFinalScore() : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
            BigDecimal q2 = recordSubEntityList.stream().filter(e -> e.getCreateTime().after((Date)quarterStartEndTime.getQ2StartTime()) && e.getCreateTime().before((Date)quarterStartEndTime.getQ2EndTime())).map(record -> record.getFinalScore() != null ? record.getFinalScore() : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
            BigDecimal q3 = recordSubEntityList.stream().filter(e -> e.getCreateTime().after((Date)quarterStartEndTime.getQ3StartTime()) && e.getCreateTime().before((Date)quarterStartEndTime.getQ3EndTime())).map(record -> record.getFinalScore() != null ? record.getFinalScore() : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
            BigDecimal q4 = recordSubEntityList.stream().filter(e -> e.getCreateTime().after((Date)quarterStartEndTime.getQ4StartTime()) && e.getCreateTime().before((Date)quarterStartEndTime.getQ4EndTime())).map(record -> record.getFinalScore() != null ? record.getFinalScore() : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
            res.setQ1(q1);
            res.setQ2(q2);
            res.setQ3(q3);
            res.setQ4(q4);
            res.setYearScore(yearScore);
            res.setTotalAnnualScore(totalAnnualScore);
            infoList.add(res);
        }
        infoList.sort(Comparator.comparing(AssessmentRankRes.AssessmentRankInfo::getTotalAnnualScore).reversed());
        return infoList;
    }

    public StatisticsServerImpl(RecordDao recordDao, RecordSubDao recordSubDao, UserDao userDao, NormDao normDao, TeamUserDao teamUserDao, SessionManager sessionManager, IRoleApi iRoleApi) {
        this.recordDao = recordDao;
        this.recordSubDao = recordSubDao;
        this.userDao = userDao;
        this.normDao = normDao;
        this.teamUserDao = teamUserDao;
        this.sessionManager = sessionManager;
        this.iRoleApi = iRoleApi;
    }
}

