package com.ejianc.business.dxcheck.dao.impl.bpm;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONArray;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.dxcheck.dao.RecordDao;
import com.ejianc.business.dxcheck.dao.RecordSubDao;
import com.ejianc.business.dxcheck.entity.RecordEntity;
import com.ejianc.business.dxcheck.entity.RecordSubEntity;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.param.CommonBusinessParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@Service("recordSub")
public class RecordSubBpmServiceImpl implements ICommonBusinessService {
    @Qualifier("com.ejianc.foundation.orgcenter.api.IUserApi")
    @Autowired
    private IUserApi iUserApi;

    @Autowired
    private RecordDao recordDao;

    @Autowired
    private RecordSubDao recordSubDao;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public CommonResponse<String> approveUserList(CommonBusinessParam businessParam) {
        logger.info("recordSub_approveUserList回调：{}", JSONUtil.toJsonStr(businessParam));
        // 元数据id(recordSub.id)
        Long metadataId = businessParam.getMetadataId();
        JSONArray newApproveInfo = businessParam.getNewApproveInfo();
        List<NewApproveInfo> newApproveInfoList = newApproveInfo.toJavaList(NewApproveInfo.class);
        List<String> approveUserIdList = Lists.newArrayList();
        List<UserVO> approveUserInfoList = Lists.newArrayList();
        String approveUserInfo = "";
        StringJoiner approveUserCode = new StringJoiner(",");
        StringJoiner approveUserName = new StringJoiner(",");
        if (!newApproveInfoList.isEmpty()) {
            newApproveInfoList.forEach(e -> {
                approveUserIdList.addAll(e.getApproveUserList());
            });
            CommonResponse<List<UserVO>> userList = iUserApi.queryListByIds(approveUserIdList.toArray(new String[0]));
            List<UserVO> data = userList.getData();
            if (userList.isSuccess() && data != null && !data.isEmpty()) {
                approveUserInfoList.addAll(data);
                for (UserVO datum : data) {
                    String userCode = datum.getUserCode();
                    String userName = datum.getUserName();
                    approveUserCode.add(userCode);
                    approveUserName.add(userName);
                }
            }
            // 获取节点审批所有用户信息
            approveUserInfo = JSONUtil.toJsonStr(approveUserInfoList);
        }
        RecordSubEntity one = recordSubDao.lambdaQuery().eq(BaseEntity::getId, metadataId).one();
        if (Objects.nonNull(one)) {
            Long recordId = one.getRecordId();
            recordSubDao.lambdaUpdate().set(RecordSubEntity::getApproveUserCode, approveUserCode.toString())
                .eq(BaseEntity::getId, metadataId).update();
            recordDao.lambdaUpdate().set(RecordEntity::getApproveUserInfo, approveUserInfo)
                .set(RecordEntity::getApproveUserName, approveUserName.toString()).eq(BaseEntity::getId, recordId)
                .update();
        }
        return CommonResponse.success();
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class NewApproveInfo {
        // 审批节点
        private String taskKey;
        // 审批节点名称
        private String taskName;
        // 节点标记
        private String sign;
        // 审批人员id列表
        private List<String> approveUserList;
    }
}
