package com.ejianc.business.dxcheck.model.res;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.List;


/**
 * @Author: LCL
 * @Date: 2024/6/4 下午4:33
 * @Description: 考核记录排名
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class AssessmentRankRes {
    /**
     * 本部
     */
    private List<AssessmentRankInfo> bb;
    /**
     * 直管项目
     */
    private List<AssessmentRankInfo> zgxm;
    /**
     * 分子公司
     */
    private List<AssessmentRankInfo> fzgs;

    @Data
    @Builder
    @AllArgsConstructor
    @NoArgsConstructor
    public static class AssessmentRankInfo {
        /**
         * 考核单位code
         */
        private String unitCode;
        /**
         * 考核单位名称
         */
        private String unitName;
        private String unitShortName;
        /**
         * 第一季度加减分
         */
        private BigDecimal q1;
        /**
         * 第二季度加减分
         */
        private BigDecimal q2;
        /**
         * 第三季度加减分
         */
        private BigDecimal q3;
        /**
         * 第四季度加减分
         */
        private BigDecimal q4;
        /**
         * 当年加减分
         */
        private BigDecimal yearScore;
        /**
         * 年度总分
         */
        private BigDecimal totalAnnualScore;
    }
}
