package com.ejianc.business.dxcheck.model.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;


/**
 * @Author: LCL
 * @Date: 2024/5/29 上午9:51
 * @Description: 考核记录新增
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class RecordAddVo {

    /**
     * 1:本部 2.直管项目 3.分子公司
     */
    @NotNull(message = "orgType不能为空")
    private Integer orgType;

    /**
     * 考核单位id
     */
    @NotEmpty(message = "考核单位id不能为空")
    private String assessmentUnitId;

    /**
     * 考核单位Code
     */
    @NotEmpty(message = "考核单位code不能为空")
    private String assessmentUnitCode;

    /**
     * 考核单位名称
     */
    @NotEmpty(message = "考核单位name不能为空")
    private String assessmentUnitName;
    /**
     * 考核单位简称
     */
    private String assessmentUnitShortName;

    /**
     * 考评事件类型（字典项：单位发起评分 考评组发起评分 专业组直接评分 考评组直接评分）
     */
    private String assessmentEventType;

    /**
     * 考核内容
     */
    private String assessmentContent;

    /**
     * 考核人员id
     */
    @ReferSerialTransfer(referCode = "idm-employee")
    private String assessorId;

    /**
     * 考核人员工号
     */
    private String assessorJobNum;

    /**
     * 考核人员
     */
    private String assessorName;

    /**
     * 专业组
     */
    private List<BaseUserInfoVo> professionalGroup;

    /**
     * 专业组人员
     */
    private String professionalGroupMembers;

    /**
     * 考评组
     */
    private List<BaseUserInfoVo> evaluationGroup;

    /**
     * 考评组人员
     */
    private String evaluationGroupMembers;

    /**
     * 新增/修改 考核记录子表信息
     */
    @NotNull(message = "指标不能为空")
    private List<RecordSubAddVo> recordSubEntityList;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class RecordSubAddVo {
        /**
         * 1:本部 2.直管项目 3.分子公司
         */
        private Integer orgType;

        /**
         * 考核单位id
         */
        private String assessmentUnitId;

        /**
         * 考核单位/部门code
         */
        private String assessmentUnitCode;
        /**
         * 考核单位/部门名称
         */
        private String assessmentUnitName;
        /**
         * 考核单位简称
         */
        private String assessmentUnitShortName;

        /**
         * 考评事件类型（字典项：单位发起评分 考评组发起评分 专业组直接评分 考评组直接评分）
         */
        private String assessmentEventType;

        /**
         * 考核内容
         */
        private String assessmentContent;

        /**
         * 考核人员id
         */
        private String assessorId;

        /**
         * 考核人员工号
         */
        private String assessorJobNum;

        /**
         * 考核人员
         */
        private String assessorName;

        /**
         * 指标id
         */
        private Long normId;

        /**
         * 指标序号
         */
        private String normNum;

        /**
         * 一级分类
         */
        private String firstClassify;

        /**
         * 二级分类
         */
        private String secondClassify;

        /**
         * 指标内容
         */
        private String normContent;

        /**
         * 加分上限
         */
        private String plusLimit;

        /**
         * 扣分上限制
         */
        private String reduceLimit;

        /**
         * 本部部门（使用选√，不适用—，也可选择单位）
         */
        private String headquarterDepartment;

        /**
         * 分子公司（使用选√，不适用—，也可选择单位）
         */
        private String subsidiaryCompany;

        /**
         * 直管项目（使用选√，不适用—，也可选择单位）
         */
        private String straightProject;

        /**
         * 指标版本
         */
        private String normVersion;

        /**
         * 指标状态
         */
        private String normState;

        /**
         * 分值所属年份（自动带入，可修改）
         */
        private String scoreOfYear;

        /**
         * 分值所属季度（自动带入，可修改）
         */
        private String scoreOfSeason;

        /**
         * 考评主题
         */
        private String assessmentSubject;

        /**
         * 自评分（单位自评）
         */
        private BigDecimal selfScore;

        /**
         * 自评理由（单位自评）
         */
        private String selfScoreReason;

        /**
         * 支持材料（单位自评）
         */
        private String supportMaterialSelf;


        /**
         * 建议评分（专业组建议）
         */
        private BigDecimal suggestScore;

        /**
         * 建议理由（专业组建议）
         */
        private String suggestReason;

        /**
         * 支撑材料（专业组建议）
         */
        private String supportMaterialMajor;

        /**
         * 初评分（初评组初审）
         */
        private BigDecimal preliminaryScore;

        /**
         * 初评理由（初评组初审）
         */
        private String preliminaryReason;

        /**
         * 支撑材料（初评组初审）
         */
        private String supportMaterialPrelim;

        /**
         * 终评分（考评组长终评）
         */
        private BigDecimal finalScore;

        /**
         * 终评理由（考评组长终评）
         */
        private String finalReason;
    }
}
