package com.ejianc.business.dxcheck.util;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.ejianc.framework.core.util.DateFormater;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang3.tuple.Pair;

import java.util.Date;

/**
 * @Author: LCL
 * @Date: 2024/6/28 下午1:49
 * @Description: 时间拓展工具类
 */
public class DateExtUtil extends DateUtil {
    private static final String Q1_START_TIME_OR_YEAR_START_TIME = "01-01 00:00:00";
    private static final String Q1_END_TIME = "03-31 23:59:59";
    private static final String Q2_START_TIME = "04-01 00:00:00";
    private static final String Q2_END_TIME = "06-30 23:59:59";
    private static final String Q3_START_TIME = "07-01 00:00:00";
    private static final String Q3_END_TIME = "09-30 23:59:59";
    private static final String Q4_START_TIME = "10-01 00:00:00";
    private static final String Q4_END_TIME_OR_YEAR_END_TIME = "12-31 23:59:59";

    /**
     * 时间连接符
     */
    public static final String TIME_JOINER = "-";

    /**
     * 获取当年或指定年的起始、结束时间
     *
     * @param year 制定年
     * @return Pair.of(yearStartTime, yearEndTime)
     */
    public static Pair<DateTime, DateTime> getYearStartEndTime(String year) {
        DateTime yearStartTime;
        DateTime yearEndTime;
        if (StrUtil.isBlank(year)) {
            yearStartTime = DateUtil.parse(DateUtil.year(new Date()) + TIME_JOINER + Q1_START_TIME_OR_YEAR_START_TIME,
                DateFormater.LONG_FORMAT);
            yearEndTime = DateUtil.parse(DateUtil.year(new Date()) + TIME_JOINER + Q4_END_TIME_OR_YEAR_END_TIME,
                DateFormater.LONG_FORMAT);
        } else {
            yearStartTime =
                DateUtil.parse(year + TIME_JOINER + Q1_START_TIME_OR_YEAR_START_TIME, DateFormater.LONG_FORMAT);
            yearEndTime = DateUtil.parse(year + TIME_JOINER + Q4_END_TIME_OR_YEAR_END_TIME, DateFormater.LONG_FORMAT);
        }

        return Pair.of(yearStartTime, yearEndTime);
    }

    /**
     * 获取当年或指定年的各个季度起始、结束时间
     *
     * @param year 制定年
     * @return Pair.of(yearStartTime, yearEndTime)
     */
    public static QuarterStartEndTime getQuarterStartEndTime(String year) {
        DateTime q1StartTime;
        DateTime q1EndTime;
        DateTime q2StartTime;
        DateTime q2EndTime;
        DateTime q3StartTime;
        DateTime q3EndTime;
        DateTime q4StartTime;
        DateTime q4EndTime;
        if (StrUtil.isBlank(year)) {
            q1StartTime = DateUtil.parse(DateUtil.year(new Date()) + TIME_JOINER + Q1_START_TIME_OR_YEAR_START_TIME,
                DateFormater.LONG_FORMAT);
            q1EndTime = DateUtil.parse(DateUtil.year(new Date()) + TIME_JOINER + Q1_END_TIME, DateFormater.LONG_FORMAT);
            q2StartTime =
                DateUtil.parse(DateUtil.year(new Date()) + TIME_JOINER + Q2_START_TIME, DateFormater.LONG_FORMAT);
            q2EndTime = DateUtil.parse(DateUtil.year(new Date()) + TIME_JOINER + Q2_END_TIME, DateFormater.LONG_FORMAT);
            q3StartTime =
                DateUtil.parse(DateUtil.year(new Date()) + TIME_JOINER + Q3_START_TIME, DateFormater.LONG_FORMAT);
            q3EndTime = DateUtil.parse(DateUtil.year(new Date()) + TIME_JOINER + Q3_END_TIME, DateFormater.LONG_FORMAT);
            q4StartTime =
                DateUtil.parse(DateUtil.year(new Date()) + TIME_JOINER + Q4_START_TIME, DateFormater.LONG_FORMAT);
            q4EndTime = DateUtil.parse(DateUtil.year(new Date()) + TIME_JOINER + Q4_END_TIME_OR_YEAR_END_TIME,
                DateFormater.LONG_FORMAT);
        } else {
            q1StartTime =
                DateUtil.parse(year + TIME_JOINER + Q1_START_TIME_OR_YEAR_START_TIME, DateFormater.LONG_FORMAT);
            q1EndTime = DateUtil.parse(year + TIME_JOINER + Q1_END_TIME, DateFormater.LONG_FORMAT);
            q2StartTime = DateUtil.parse(year + TIME_JOINER + Q2_START_TIME, DateFormater.LONG_FORMAT);
            q2EndTime = DateUtil.parse(year + TIME_JOINER + Q2_END_TIME, DateFormater.LONG_FORMAT);
            q3StartTime = DateUtil.parse(year + TIME_JOINER + Q3_START_TIME, DateFormater.LONG_FORMAT);
            q3EndTime = DateUtil.parse(year + TIME_JOINER + Q3_END_TIME, DateFormater.LONG_FORMAT);
            q4StartTime = DateUtil.parse(year + TIME_JOINER + Q4_START_TIME, DateFormater.LONG_FORMAT);
            q4EndTime = DateUtil.parse(year + TIME_JOINER + Q4_END_TIME_OR_YEAR_END_TIME, DateFormater.LONG_FORMAT);
        }
        return QuarterStartEndTime.builder().q1StartTime(q1StartTime).q1EndTime(q1EndTime).q2StartTime(q2StartTime)
            .q2EndTime(q2EndTime).q3StartTime(q3StartTime).q3EndTime(q3EndTime).q4StartTime(q4StartTime)
            .q4EndTime(q4EndTime).build();
    }

    @Data
    @Builder
    @AllArgsConstructor
    @NoArgsConstructor
    public static class QuarterStartEndTime {
        private DateTime q1StartTime;
        private DateTime q1EndTime;
        private DateTime q2StartTime;
        private DateTime q2EndTime;
        private DateTime q3StartTime;
        private DateTime q3EndTime;
        private DateTime q4StartTime;
        private DateTime q4EndTime;
    }
}
