package com.ejianc.business.dxcheck.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

/**
 * @Author: LCL
 * @Date: 2024/5/28 上午9:53
 * @Description: 考核记录指标信息
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
@TableName("ejc_dxcheck_record_sub")
@Builder
public class RecordSubEntity extends BaseEntity {
    /**
     * 当前审批人员code
     */
    @TableField(value = "approve_user_code")
    @JsonFormat(with = JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY)
    private String approveUserCode;
    /**
     * 考核记录id
     */
    @TableField(value = "record_id")
    private Long recordId;

    /**
     * 1:本部 2.直管项目 3.分子公司
     */
    @TableField(value = "org_type")
    private Integer orgType;

    /**
     * 考核单位id
     */
    @TableField(value = "assessment_unit_id")
    private String assessmentUnitId;

    /**
     * 考核单位code
     */
    @TableField(value = "assessment_unit_code")
    private String assessmentUnitCode;

    /**
     * 考核单位名称
     */
    @TableField(value = "assessment_unit_name")
    private String assessmentUnitName;

    /**
     * 考核单位简称
     */
    @TableField(value = "assessment_unit_short_name")
    private String assessmentUnitShortName;

    /**
     * 考评事件类型（字典项：被考核对象申请评分 考评组发起评分 专业组直接评分 考评组直接评分）
     */
    @TableField(value = "assessment_event_type")
    private String assessmentEventType;

    /**
     * 考核内容
     */
    @TableField(value = "assessment_content")
    private String assessmentContent;

    /**
     * 考核人员id
     */
    @TableField(value = "assessor_id")
    private String assessorId;

    /**
     * 考核人员工号
     */
    @TableField(value = "assessor_job_num")
    private String assessorJobNum;

    /**
     * 考核人员
     */
    @TableField(value = "assessor_name")
    private String assessorName;

    /**
     * 修改人工号
     */
    @TableField(value = "modifier_job_num")
    private String modifierJobNum;

    /**
     * 指标id
     */
    @TableField(value = "norm_id")
    private Long normId;

    /**
     * 指标序号
     */
    @TableField(value = "norm_num")
    private String normNum;

    /**
     * 一级分类
     */
    @TableField(value = "first_classify")
    private String firstClassify;

    /**
     * 二级分类
     */
    @TableField(value = "second_classify")
    private String secondClassify;

    /**
     * 指标内容
     */
    @TableField(value = "norm_content")
    private String normContent;

    /**
     * 加分上限
     */
    @TableField(value = "plus_limit")
    private String plusLimit;

    /**
     * 扣分上限制
     */
    @TableField(value = "reduce_limit")
    private String reduceLimit;

    /**
     * 本部部门（使用选√，不适用—，也可选择单位）
     */
    @TableField(value = "headquarter_department")
    private String headquarterDepartment;

    /**
     * 分子公司（使用选√，不适用—，也可选择单位）
     */
    @TableField(value = "subsidiary_company")
    private String subsidiaryCompany;

    /**
     * 直管项目（使用选√，不适用—，也可选择单位）
     */
    @TableField(value = "straight_project")
    private String straightProject;

    /**
     * 指标版本
     */
    @TableField(value = "norm_version")
    private String normVersion;

    /**
     * 指标状态
     */
    @TableField(value = "norm_state")
    private String normState;

    /**
     * 分值所属年份（自动带入，可修改）
     */
    @TableField(value = "scoreOfYear")
    private String scoreOfYear;

    /**
     * 分值所属季度（自动带入，可修改）
     */
    @TableField(value = "scoreOfSeason")
    private String scoreOfSeason;

    /**
     * 考评主题
     */
    @TableField(value = "assessment_subject")
    private String assessmentSubject;

    /**
     * 状态：（0新增完成；1待考核对象自评；2待考评组选择专业组；3待专业组评分；4待考评组评分；5待考评组长评分；6考评完成）
     */
    @TableField(value = "state")
    private Integer state;

    /**
     * 自评分（单位自评）
     */
    @TableField(value = "self_score")
    private BigDecimal selfScore;

    /**
     * 自评理由（单位自评）
     */
    @TableField(value = "self_score_reason")
    private String selfScoreReason;

    /**
     * 支持材料（单位自评）
     */
    @TableField(value = "support_material_self")
    private String supportMaterialSelf;

    /**
     * 支持材料（单位自评）名称
     */
    @TableField(value = "support_material_self_name")
    private String supportMaterialSelfName;

    /**
     * 建议评分（专业组建议）
     */
    @TableField(value = "suggest_score")
    private BigDecimal suggestScore;

    /**
     * 建议理由（专业组建议）
     */
    @TableField(value = "suggest_reason")
    private String suggestReason;

    /**
     * 支撑材料（专业组建议）
     */
    @TableField(value = "support_material_major")
    private String supportMaterialMajor;

    /**
     * 支撑材料（专业组建议）名称
     */
    @TableField(value = "support_material_major_name")
    private String supportMaterialMajorName;

    /**
     * 初评分（初评组初审）
     */
    @TableField(value = "preliminary_score")
    private BigDecimal preliminaryScore;

    /**
     * 初评理由（初评组初审）
     */
    @TableField(value = "preliminary_reason")
    private String preliminaryReason;

    /**
     * 支撑材料（初评组初审）
     */
    @TableField(value = "support_material_prelim")
    private String supportMaterialPrelim;

    /**
     * 支撑材料（初评组初审）名称
     */
    @TableField(value = "support_material_prelim_name")
    private String supportMaterialPrelimName;

    /**
     * 终评分（考评组长终评）
     */
    @TableField(value = "final_score")
    private BigDecimal finalScore;

    /**
     * 终评理由（考评组长终评）
     */
    @TableField(value = "final_reason")
    private String finalReason;
}
