package com.ejianc.business.dxcheck.dao.impl.bpm;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONArray;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.dxcheck.dao.RecordDao;
import com.ejianc.business.dxcheck.dao.RecordSubDao;
import com.ejianc.business.dxcheck.entity.RecordEntity;
import com.ejianc.business.dxcheck.entity.RecordSubEntity;
import com.ejianc.business.dxcheck.model.res.NewApproveInfoRes;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.param.CommonBusinessParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;

import cn.hutool.json.JSONUtil;

/**
 * @Author: LCL
 * @Date: 2024/6/28 下午2:41
 */
@Service("record")
public class RecordBpmServiceImpl implements ICommonBusinessService {
    @Qualifier("com.ejianc.foundation.orgcenter.api.IUserApi")
    @Autowired
    private IUserApi iUserApi;

    @Autowired
    private RecordDao recordDao;

    @Autowired
    private RecordSubDao recordSubDao;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    /**
     * 提交完回调
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        RecordEntity recordEntity = recordDao.selectById(billId);
        if (Objects.isNull(recordEntity)) {
            return null;
        }
        String assessmentEventType = recordEntity.getAssessmentEventType();
        Integer state1 = recordEntity.getState();

        /*
          assessmentEventType 考评事件类型（字典项：被考核对象申请评分 专业组直接评分 考评组发起评分 考评组直接评分）
          状态：（-1确认状态 0新增完成；1待考核对象自评；2待考评组选择专业组；3待专业组评分；4待考评组评分；5待考评组长评分；6考评完成）
         */
        if ("被考核对象申请评分".equals(assessmentEventType)) {
            recordDao.synchronizationState(billId, 2);
        }
        if ("专业组直接评分".equals(assessmentEventType)) {
            recordDao.synchronizationState(billId, -1);
        }
        if ("考评组直接评分".equals(assessmentEventType)) {
            recordDao.synchronizationState(billId, 5);
        }

        /*
          该流程 分数需要重头开始打分
         */
        if ("考评组发起评分".equals(assessmentEventType) && state1 == 0) {
            recordDao.synchronizationState(billId, 1);
        }
        if ("考评组发起评分".equals(assessmentEventType) && state1 == 1) {
            recordDao.synchronizationState(billId, 2);
        }

        return CommonResponse.success();
    }

    /**
     * 审批节点审批中时，节点审批前回调
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    /**
     * 审批节点审批中时，节点审批后回调
     */
    @Override
    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId,
        Boolean isEnd, String sign, Map<String, Object> other) {
        RecordEntity byId = recordDao.getById(billId);
        if (Objects.isNull(byId)) {
            return CommonResponse.success();
        }
        if (isEnd) {
            Integer recordState = byId.getState();
            Integer statee = byId.getStatee();
            String assessmentEventType = byId.getAssessmentEventType();
            if ("专业组直接评分".equals(assessmentEventType) && byId.getState() == -1) {
                // if (Objects.isNull(statee)) {
                // recordDao.synchronizationState(billId, -1);
                // recordDao.lambdaUpdate().set(BaseEntity::getId, billId).set(RecordEntity::getStatee, 999).update();
                // return CommonResponse.success();
                // }
                recordDao.synchronizationState(billId, 2);
                return CommonResponse.success();
            }
            if ("专业组直接评分".equals(assessmentEventType) && byId.getState() == 2) {
                recordDao.synchronizationState(billId, 4);
                return CommonResponse.success();
            }
            if ("考评组发起评分".equals(assessmentEventType) && recordState == 1) {
                recordDao.synchronizationState(billId, 2);
                return CommonResponse.success();
            }
            if (recordState == 1) {
                recordDao.synchronizationState(billId, 3);
                return CommonResponse.success();
            }
            recordDao.synchronizationState(billId, recordState + 1);
        }
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        recordDao.synchronizationState(billId, 6);
        return CommonResponse.success();
    }

    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        RecordEntity recordEntity = recordDao.lambdaQuery().eq(BaseEntity::getId, billId).one();
        String assessmentEventType = recordEntity.getAssessmentEventType();
        /*
          退回时，除了考评组退回到  1待考评对象自评 其他均退回到 0新增完成
         */
        if ("考评组发起评分".equals(assessmentEventType)) {
            recordDao.synchronizationState(billId, 1);
        } else {
            recordDao.synchronizationState(billId, 0);

        }
        return CommonResponse.success();
    }

    @Override
    public CommonResponse<String> approveUserList(CommonBusinessParam businessParam) {
        logger.info("record_approveUserList回调：{}", JSONUtil.toJsonStr(businessParam));
        // 元数据id(record.id)
        Long billId = businessParam.getBillId();
        JSONArray newApproveInfo = businessParam.getNewApproveInfo();
        List<NewApproveInfoRes> newApproveInfoResList = newApproveInfo.toJavaList(NewApproveInfoRes.class);
        List<String> approveUserIdList = Lists.newArrayList();
        List<UserVO> approveUserInfoList = Lists.newArrayList();
        StringJoiner approveUserCode = new StringJoiner(",");
        StringJoiner approveUserName = new StringJoiner(",");
        String approveUserInfo = "";
        if (!newApproveInfoResList.isEmpty()) {
            newApproveInfoResList.forEach(e -> approveUserIdList.addAll(e.getApproveUserList()));
            CommonResponse<List<UserVO>> userList = iUserApi.queryListByIds(approveUserIdList.toArray(new String[0]));
            List<UserVO> data = userList.getData();
            if (userList.isSuccess() && data != null && !data.isEmpty()) {
                approveUserInfoList.addAll(data);
                for (UserVO datum : data) {
                    String userCode = datum.getUserCode();
                    String userName = datum.getUserName();
                    approveUserCode.add(userCode);
                    approveUserName.add(userName);
                }
            }
            // 获取节点审批所有用户信息
            approveUserInfo = JSONUtil.toJsonStr(approveUserInfoList);
        }
        RecordEntity one = recordDao.lambdaQuery().eq(BaseEntity::getId, billId).one();
        if (Objects.nonNull(one)) {
            recordDao.lambdaUpdate().set(RecordEntity::getApproveUserInfo, approveUserInfo)
                .set(RecordEntity::getApproveUserCode, approveUserCode.toString())
                .set(RecordEntity::getApproveUserName, approveUserName.toString()).eq(BaseEntity::getId, billId)
                .update();
            recordSubDao.lambdaUpdate().set(RecordSubEntity::getApproveUserCode, approveUserCode.toString())
                .eq(RecordSubEntity::getRecordId, billId).update();
        }
        return CommonResponse.success();
    }

}
