package com.ejianc.business.dxcheck.model.vo;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @Author: LCL
 * @Date: 2024/6/4 下午2:05
 * @Description: 批量新增
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class RecordBatchAddVo {
    /**
     * 考评事件类型（字典项：单位发起评分 考评组发起评分 专业组直接评分 考评组直接评分）
     */
    @NotEmpty(message = "考评事件类型不能为空")
    private String assessmentEventType;

    /**
     * 考核内容
     */
    @NotEmpty(message = "考核内容不能为空")
    private String assessmentContent;
    /**
     * 批量新增 考核记录子表信息
     */
    @NotNull(message = "考核单位不能为空")
    private List<RecordAddVo> recordInfos;

    /**
     * 批量新增 考核记录子表信息
     */
    @NotNull(message = "指标不能为空")
    private List<RecordAddVo.RecordSubAddVo> recordSubEntityList;
}
