package com.ejianc.business.dxcheck.controller;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejianc.business.dxcheck.model.res.AssessmentRankRes;
import com.ejianc.business.dxcheck.model.vo.NormScoreVo;
import com.ejianc.business.dxcheck.service.StatisticsServer;
import com.ejianc.framework.core.response.CommonResponse;

import cn.hutool.json.JSONArray;
import lombok.RequiredArgsConstructor;

/**
 * @Author: LCL
 * @Date: 2024/6/4 下午3:35
 * @Description: 统计
 */
@Controller
@RequestMapping("statistics")
@RequiredArgsConstructor
public class StatisticsController {
    private final StatisticsServer server;

    /**
     * 考评工作处理提示
     *
     * @return JSONArray
     */
    @RequestMapping(value = "tips", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONArray> tips(@RequestParam("year") String year) {
        return CommonResponse.success("考评工作处理提示", server.tips(year));
    }

    /**
     * 获取排名组织树
     */
    @RequestMapping(value = "getTree", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONArray> getTree() {
        return CommonResponse.success("获取排名组织树", server.getTree());
    }

    /**
     * 考核排名统计
     *
     * @return AssessmentRankRes
     */
    @RequestMapping(value = "assessmentRank", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<AssessmentRankRes> assessmentRank(@RequestParam("year") String year) {
        return CommonResponse.success("考核排名统计", server.assessmentRank(year));
    }

    /**
     * 考核记录统计
     *
     * @param unitCode 部门代码
     * @return 汇总数据
     */
    @RequestMapping(value = "record", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONArray> record(@RequestParam("unitCode") String unitCode,
        @RequestParam("year") String year) {
        return CommonResponse.success("考核记录统计", server.record(unitCode, year));
    }

    /**
     * 获取最新记录（加分、减分）
     *
     * @return 数据
     */
    @RequestMapping(value = "getNewRecord", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONArray> getNewRecord(@RequestParam("pageNo") Integer pageNo,
                                                  @RequestParam("pageSize") Integer pageSize) {
        return CommonResponse.success("考核记录统计", server.getNewRecord(pageNo,pageSize));
    }

    /**
     * 指标计算
     */
    @RequestMapping(value = "normScore", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONArray> normScore(@RequestBody NormScoreVo vo) {
        return CommonResponse.success("指标计算", server.normScore(vo));
    }

}
