package com.ejianc.business.dxcheck.service.impl;/* author Wyx */

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.dxcheck.dao.TeamDao;
import com.ejianc.business.dxcheck.dao.TeamUserDao;
import com.ejianc.business.dxcheck.entity.TeamEntity;
import com.ejianc.business.dxcheck.entity.TeamUserEntity;
import com.ejianc.business.dxcheck.mapper.TeamMapper;
import com.ejianc.business.dxcheck.model.vo.TeamUserVO;
import com.ejianc.business.dxcheck.model.vo.TeamVO;
import com.ejianc.business.dxcheck.service.TeamService;
import com.ejianc.business.dxcheck.service.TeamUserService;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service("teamService")
public class TeamServiceImpl extends BaseServiceImpl<TeamMapper, TeamEntity> implements TeamService {
    @Autowired
    private TeamDao teamDao;
    @Autowired
    private TeamUserDao teamUserDao;
    @Autowired
    private TeamUserService teamUserService;
    @Autowired
    private SessionManager sessionManager;

    @Override
    public TeamVO searchDetail(Long id) {
        LambdaQueryWrapper<TeamEntity> wrapper = new LambdaQueryWrapper<>();
        if (id != null) {
            wrapper.eq(TeamEntity::getId, id);
        }
        TeamEntity teamEntity = teamDao.getOne(wrapper);
        TeamVO vo = BeanMapper.map(teamEntity, TeamVO.class);
        LambdaQueryWrapper<TeamUserEntity> wrapperTeamUser = new LambdaQueryWrapper<>();
        if (vo.getId() != null) {
            wrapperTeamUser.eq(TeamUserEntity::getTeamId, vo.getId());
        }
        List<TeamUserEntity> list = teamUserDao.list(wrapperTeamUser);
        List<TeamUserVO> listVo = BeanMapper.mapList(list, TeamUserVO.class);
        vo.setTeamUserList(listVo);

        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TeamVO saveOrUpdateTeamUser(TeamVO saveOrUpdateVO) {
        TeamEntity entity = BeanMapper.map(saveOrUpdateVO, TeamEntity.class);
        saveOrUpdate(entity, false);
        TeamVO vo = BeanMapper.map(entity, TeamVO.class);
        if (saveOrUpdateVO.getTeamUserList() != null) {
            List<TeamUserVO> teamUserVOS = new ArrayList<>();
            Map<Long, TeamUserEntity> teamUserEntityMap =
                teamUserService.lambdaQuery().eq(BaseEntity::getDr, 0L).eq(TeamUserEntity::getTeamId, vo.getId()).list()
                    .stream().collect(Collectors.toMap(TeamUserEntity::getTeamUserId, Function.identity()));
            for (TeamUserVO teamUserVO : saveOrUpdateVO.getTeamUserList()) {
                if (!"del".equals(teamUserVO.getRowState())) {
                teamUserVO.setTeamId(vo.getId());
                TeamUserEntity teamUserEntity = BeanMapper.map(teamUserVO, TeamUserEntity.class);
                teamUserService.saveOrUpdate(teamUserEntity, false);
                TeamUserVO map = BeanMapper.map(teamUserEntity, TeamUserVO.class);
                teamUserVOS.add(map);
                }else {
                    LambdaQueryWrapper<TeamUserEntity> teamUserEntityWrapper = new LambdaQueryWrapper<>();
                    teamUserEntityWrapper.eq(TeamUserEntity::getId, teamUserVO.getId());
                    teamUserService.remove(teamUserEntityWrapper);

                }
            }
            vo.setTeamUserList(teamUserVOS);
        }
        return vo;
    }

    @Override
    public IPage<TeamVO> setTeamUserList(IPage<TeamVO> pageData) {

        pageData.getRecords().forEach(this::setTeamUserList);
        return pageData;
    }

    private void setTeamUserList(TeamVO teamVO) {
        System.out.println("开始遍历");
        LambdaQueryWrapper<TeamUserEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(TeamUserEntity::getTeamId, teamVO.getId());
        List<TeamUserEntity> list = teamUserDao.list(wrapper);
        List<TeamUserVO> listVo = BeanMapper.mapList(list, TeamUserVO.class);
        System.out.println("列表长度" + listVo.size());
        if (!listVo.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < listVo.size(); i++) {
                sb.append(listVo.get(i).getTeamUserId());
                // 如果不是最后一个元素，则添加逗号
                if (i < listVo.size() - 1) {
                    sb.append(",");
                }
            }
            teamVO.setTeamUsersId(sb.toString());
        }
    }

    // @Override
    // public IPage<TeamEntity> queryPageTeamType(QueryParam param, int teamType) {
    // Page<TeamEntity> page = new Page<>(param.getPageIndex(), param.getPageSize());
    // LambdaQueryWrapper<TeamEntity> wrapper = new LambdaQueryWrapper<>();
    // if (teamType == 1|| teamType==2){
    // wrapper.eq(TeamEntity::getTeamType, teamType);
    // }else {
    // return null;
    // }
    // IPage<TeamEntity> page1 = teamDao.page(page, wrapper);
    // return page1;
    // }
    /**
     * 根据当前登录人获取他所在的所有考评组信息
     */
    @Override
    public CommonResponse<List<TeamVO>> getAssessmentTeam() {
        Long userId = sessionManager.getUserContext().getUserId();
        List<TeamUserEntity> list =
            teamUserService.lambdaQuery().eq(BaseEntity::getDr, 0L).eq(TeamUserEntity::getTeamUserId, userId).list();
        if (CollUtil.isEmpty(list)) {
            return CommonResponse.success("当前登录人所在的考评组列表", Lists.newArrayList());
        }
        Set<Long> teamIds = list.stream().map(TeamUserEntity::getTeamId).collect(Collectors.toSet());
        List<TeamEntity> list1 = lambdaQuery().eq(BaseEntity::getDr, 0L).in(BaseEntity::getId, teamIds)
            .eq(TeamEntity::getTeamType, 1).list();
        if (CollUtil.isEmpty(list1)) {
            return CommonResponse.success("当前登录人所在的考评组列表", Lists.newArrayList());
        }
        List<TeamVO> teamVOS = BeanMapper.mapList(list1, TeamVO.class);
        teamVOS.forEach(this::setTeamUserList);
        return CommonResponse.success("当前登录人所在的考评组列表", teamVOS);
    }
}
