/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.ecard.controller;

import com.alibaba.fastjson.JSON;
import com.ejianc.business.ecard.vo.WxConfigResponse;
import com.ejianc.business.ecard.vo.WxShareResponse;
import com.ejianc.foundation.usercenter.api.IThirdSystemApi;
import com.ejianc.framework.core.response.CommonResponse;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.client.RestTemplate;

@Controller
@RequestMapping(value={"ecard"})
public class EcardController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${wx.config.token}")
    private String TOKEN;
    @Value(value="${wx.config.appid}")
    private String appid;
    @Value(value="${wx.config.secret}")
    private String secret;
    @Resource
    private RestTemplate restTemplate;
    @Autowired
    private IThirdSystemApi thirdSystemService;
    @Autowired
    private RedisTemplate redisTemplate;

    @Bean
    public RestTemplate restTemplate(RestTemplateBuilder builder) {
        return builder.build();
    }

    @GetMapping(value={"/getWxConfig"}, produces={"text/html;charset=utf-8"})
    @ResponseBody
    public String getWxConfig(@RequestParam(value="signature") String signature, @RequestParam(value="timestamp") String timestamp, @RequestParam(value="nonce") String nonce, @RequestParam(value="echostr") String echostr) {
        Object[] arr = new String[]{this.TOKEN, timestamp, nonce};
        Arrays.sort(arr);
        StringBuilder content = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            content.append((String)arr[i]);
        }
        MessageDigest md = null;
        String temp = null;
        try {
            md = MessageDigest.getInstance("SHA-1");
            byte[] digest = md.digest(content.toString().getBytes());
            temp = EcardController.byteToStr(digest);
            this.logger.info("\u52a0\u5bc6\u540e\u7684token:" + temp);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        if (temp.toLowerCase().equals(signature)) {
            return echostr;
        }
        return null;
    }

    @RequestMapping(value={"/share"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<WxShareResponse> checkWx(String url) {
        this.logger.info("/share\u8f93\u5165\u7684\u6570\u636e\uff1a{}", (Object)url);
        WxShareResponse wxShareResponse = this.queryWxShare(url);
        this.logger.info("/share\u5373\u5c06\u8f93\u51fa\u7684\u6570\u636e\uff1a{}", JSON.toJSON((Object)wxShareResponse));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)wxShareResponse);
    }

    public WxShareResponse queryWxShare(String url) {
        WxShareResponse wxShareResponse = new WxShareResponse();
        String getTokenUrl = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=" + this.appid + "&secret=" + this.secret;
        WxConfigResponse wxToken = (WxConfigResponse)this.restTemplate.getForObject(getTokenUrl, WxConfigResponse.class, new Object[0]);
        String accessToken = wxToken.getAccess_token();
        if (wxToken.getErrcode() != null && wxToken.getErrcode() != 0L) {
            wxShareResponse.setErrcode(wxToken.getErrcode());
            wxShareResponse.setErrmsg(wxToken.getErrmsg());
            return wxShareResponse;
        }
        String getTicketUrl = "https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token=" + accessToken + "&type=jsapi";
        WxConfigResponse wxTicket = (WxConfigResponse)this.restTemplate.getForObject(getTicketUrl, WxConfigResponse.class, new Object[0]);
        String ticket = wxTicket.getTicket();
        System.out.println(wxTicket);
        if (wxTicket.getErrcode() != null && wxTicket.getErrcode() != 0L) {
            wxShareResponse.setErrcode(wxTicket.getErrcode());
            wxShareResponse.setErrmsg(wxTicket.getErrmsg());
            return wxShareResponse;
        }
        String noncestr = UUID.randomUUID().toString();
        String timestamp = Long.toString(System.currentTimeMillis() / 1000L);
        String getSign = "jsapi_ticket=" + ticket + "&noncestr=" + noncestr + "&timestamp=" + timestamp + "&url=" + url;
        String signature = EcardController.getSha1(getSign);
        wxShareResponse.setNoncestr(noncestr);
        wxShareResponse.setTimestamp(timestamp);
        wxShareResponse.setSignature(signature);
        wxShareResponse.setAppid(this.appid);
        return wxShareResponse;
    }

    public WxShareResponse queryWorkWxShare(String url) {
        WxShareResponse wxShareResponse = new WxShareResponse();
        String accessToken = null;
        String key1 = "wxcc9a690e5c66855c_accessToken";
        String key2 = "wxcc9a690e5c66855c_ticket";
        accessToken = (String)this.redisTemplate.opsForValue().get((Object)key1);
        this.logger.info("redis----accessToken=" + accessToken);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            String getTokenUrl = "https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid=wxcc9a690e5c66855c&corpsecret=dBMuo3hXenzW-6B3U8BfscMDQWSr3ET1nfwUaqDPi40&debug=1";
            WxConfigResponse wxToken = (WxConfigResponse)this.restTemplate.getForObject(getTokenUrl, WxConfigResponse.class, new Object[0]);
            accessToken = wxToken.getAccess_token();
            this.logger.info("accessToken: " + accessToken);
            if (wxToken.getErrcode() != null && wxToken.getErrcode() != 0L) {
                wxShareResponse.setErrcode(wxToken.getErrcode());
                wxShareResponse.setErrmsg(wxToken.getErrmsg());
                return wxShareResponse;
            }
            if (StringUtils.isNotBlank((CharSequence)accessToken)) {
                this.redisTemplate.opsForValue().set((Object)key1, (Object)accessToken, 7000L, TimeUnit.SECONDS);
            }
        }
        String ticket = (String)this.redisTemplate.opsForValue().get((Object)key2);
        this.logger.info("redis----ticket=" + ticket);
        if (StringUtils.isBlank((CharSequence)ticket)) {
            String getTicketUrl = "https://qyapi.weixin.qq.com/cgi-bin/ticket/get?access_token=" + accessToken + "&type=agent_config&debug=1";
            WxConfigResponse wxTicket = (WxConfigResponse)this.restTemplate.getForObject(getTicketUrl, WxConfigResponse.class, new Object[0]);
            ticket = wxTicket.getTicket();
            this.logger.info("ticket: " + ticket);
            if (wxTicket.getErrcode() != null && wxTicket.getErrcode() != 0L) {
                wxShareResponse.setErrcode(wxTicket.getErrcode());
                wxShareResponse.setErrmsg(wxTicket.getErrmsg());
                return wxShareResponse;
            }
            if (StringUtils.isNotBlank((CharSequence)ticket)) {
                this.redisTemplate.opsForValue().set((Object)key2, (Object)ticket, 7000L, TimeUnit.SECONDS);
            }
        }
        String noncestr = UUID.randomUUID().toString();
        String timestamp = Long.toString(System.currentTimeMillis() / 1000L);
        String getSign = "jsapi_ticket=" + ticket + "&noncestr=" + noncestr + "&timestamp=" + timestamp + "&url=" + url;
        String signature = EcardController.getSha1(getSign);
        wxShareResponse.setNoncestr(noncestr);
        wxShareResponse.setTimestamp(timestamp);
        wxShareResponse.setSignature(signature);
        wxShareResponse.setAppid("wxcc9a690e5c66855c");
        return wxShareResponse;
    }

    private static String byteToStr(byte[] byteArray) {
        String strDigest = "";
        for (int i = 0; i < byteArray.length; ++i) {
            strDigest = strDigest + EcardController.byteToHexStr(byteArray[i]);
        }
        return strDigest;
    }

    private static String byteToHexStr(byte mByte) {
        char[] Digit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] tempArr = new char[]{Digit[mByte >>> 4 & 0xF], Digit[mByte & 0xF]};
        String s = new String(tempArr);
        return s;
    }

    public static String getSha1(String inStr) {
        byte[] byteArray;
        MessageDigest sha = null;
        try {
            sha = MessageDigest.getInstance("SHA");
            byteArray = inStr.getBytes("UTF-8");
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
            return "";
        }
        byte[] md5Bytes = sha.digest(byteArray);
        StringBuffer hexValue = new StringBuffer();
        for (int i = 0; i < md5Bytes.length; ++i) {
            int val = md5Bytes[i] & 0xFF;
            if (val < 16) {
                hexValue.append("0");
            }
            hexValue.append(Integer.toHexString(val));
        }
        return hexValue.toString();
    }

    @RequestMapping(value={"/shareWork"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<WxShareResponse> shareWork(String url) {
        this.logger.info("/share\u8f93\u5165\u7684\u6570\u636e\uff1a{}", (Object)url);
        WxShareResponse wxShareResponse = this.queryWorkWxShare(url);
        this.logger.info("/share\u5373\u5c06\u8f93\u51fa\u7684\u6570\u636e\uff1a{}", JSON.toJSON((Object)wxShareResponse));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)wxShareResponse);
    }

    public static void main(String[] args) {
        String l = String.valueOf(System.currentTimeMillis() / 1000L);
        System.out.println(l);
    }

    public String get(String url) throws Exception {
        String content = null;
        URLConnection urlConnection = new URL(url).openConnection();
        HttpURLConnection connection = (HttpURLConnection)urlConnection;
        connection.setRequestMethod("GET");
        connection.connect();
        int responseCode = connection.getResponseCode();
        if (responseCode == 200) {
            String l;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
            StringBuilder bs = new StringBuilder();
            while ((l = bufferedReader.readLine()) != null) {
                bs.append(l).append("\n");
            }
            content = bs.toString();
        }
        return content;
    }
}

