/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.article.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.article.bean.ArticleEntity;
import com.ejianc.business.article.service.IArticleService;
import com.ejianc.business.article.vo.ArticleVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"article"})
public class ArticleController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IArticleService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private CacheManager cacheManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ArticleVO> saveOrUpdate(@RequestBody ArticleVO saveOrUpdateVO) {
        List data;
        ArticleEntity entity = (ArticleEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ArticleEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("sourceIds", Arrays.asList(entity.getId()));
        this.attachmentApi.queryAllBySourceIdList(jsonObject);
        CommonResponse listCommonResponse = this.attachmentApi.queryAllBySourceIdList(jsonObject);
        if (listCommonResponse.isSuccess() && ListUtil.isNotEmpty((List)(data = (List)listCommonResponse.getData()))) {
            entity.setFileId(((AttachmentVO)data.get(0)).getId());
            entity.setFilePath(((AttachmentVO)data.get(0)).getFilePath());
            this.service.saveOrUpdate((Object)entity, false);
        }
        ArticleVO vo = (ArticleVO)BeanMapper.map((Object)((Object)entity), ArticleVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ArticleVO> queryDetail(Long id) {
        ArticleEntity entity = (ArticleEntity)((Object)this.service.selectById(id));
        ArticleVO vo = (ArticleVO)BeanMapper.map((Object)((Object)entity), ArticleVO.class);
        String clickNum = (String)((Object)this.cacheManager.hget("article::", vo.getId().toString()));
        if (clickNum != null) {
            clickNum = (String)((Object)this.cacheManager.hget("article::", vo.getId().toString()));
            this.cacheManager.hset("article::", vo.getId().toString(), (Serializable)((Object)String.valueOf(Integer.parseInt(clickNum) + 1)));
            this.cacheManager.expire("article::", 3600);
        } else {
            this.cacheManager.hset("article::", vo.getId().toString(), (Serializable)((Object)String.valueOf(vo.getClickNum() + 1)));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/synCacheDataTask"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Void> synCacheDataTask(HttpServletRequest request) {
        Map map = this.cacheManager.hgetAll("article::");
        for (Map.Entry entry : map.entrySet()) {
            String key = new String((byte[])entry.getKey());
            String value = (String)((Object)this.cacheManager.hget("article::", key));
            boolean update = this.service.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(ArticleEntity::getClickNum, (Object)Integer.parseInt(value))).eq(BaseEntity::getId, (Object)key));
            if (update) {
                this.logger.info(key + "\u66f4\u65b0\u6d4f\u89c8\u6b21\u6570\u6210\u529f!");
                continue;
            }
            this.logger.info(key + "\u66f4\u65b0\u6d4f\u89c8\u6b21\u6570\u5931\u8d25!");
        }
        return CommonResponse.success((String)"\u5b9a\u65f6\u4efb\u52a1\uff0c\u8eab\u4efd\u8bc1\u548c\u4eba\u8138\u6821\u9a8c\u6267\u884c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ArticleVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ArticleVO articleVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ArticleVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("title");
        fuzzyFields.add("dutyPersonName");
        fuzzyFields.add("dutyPersonName");
        fuzzyFields.add("typeName");
        fuzzyFields.add("keyWord");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ArticleVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Article-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refArticleData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ArticleVO>> refArticleData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ArticleVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

