/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.weixinee.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.hr.api.IBaseUserApi;
import com.ejianc.business.hr.vo.UserDataVO;
import com.ejianc.business.weixinee.bean.LeaveRequestEntity;
import com.ejianc.business.weixinee.service.ILeaveRequestService;
import com.ejianc.business.weixinee.vo.LeaveRequestLeaderDTO;
import com.ejianc.business.weixinee.vo.LeaveRequestVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"leaveRequest"})
public class LeaveRequestController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private ILeaveRequestService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBaseUserApi baseUserApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<LeaveRequestVO> saveOrUpdate(@RequestBody LeaveRequestVO saveOrUpdateVO) {
        LeaveRequestEntity entity = (LeaveRequestEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, LeaveRequestEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        LeaveRequestVO vo = (LeaveRequestVO)BeanMapper.map((Object)((Object)entity), LeaveRequestVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<LeaveRequestVO> queryDetail(Long id) {
        LeaveRequestEntity entity = (LeaveRequestEntity)((Object)this.service.selectById(id));
        LeaveRequestVO vo = (LeaveRequestVO)BeanMapper.map((Object)((Object)entity), LeaveRequestVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<LeaveRequestVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (LeaveRequestVO leaveRequestVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<LeaveRequestVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("userName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("spStatus", new Parameter("eq", (Object)2));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), LeaveRequestVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("LeaveRequest-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refLeaveRequestData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<LeaveRequestVO>> refLeaveRequestData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), LeaveRequestVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryListLeader"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<LeaveRequestLeaderDTO>> queryListLeader(@RequestBody QueryParam param) {
        List records;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("userName");
        QueryParam param2 = new QueryParam();
        param2.getParams().put("spStatus", new Parameter("eq", (Object)2));
        long timestamp = new Date().getTime() / 1000L;
        param2.getParams().put("newBegin", new Parameter("le", (Object)timestamp));
        param2.getParams().put("newEnd", new Parameter("ge", (Object)timestamp));
        IPage page = this.service.queryPage(param2, false);
        Map collect = page.getRecords().stream().collect(Collectors.toMap(LeaveRequestEntity::getUserName, Function.identity(), (key1, key2) -> key2));
        ArrayList<LeaveRequestLeaderDTO> leaveRequestDTOS = new ArrayList<LeaveRequestLeaderDTO>();
        QueryParam param1 = new QueryParam();
        param1.setSearchText(param.getSearchText());
        List fuzzyFields1 = param1.getFuzzyFields();
        fuzzyFields1.add("name");
        param1.setPageSize(50);
        param1.setPageIndex(1);
        param1.getParams().put("orgId", new Parameter("eq", (Object)"1502571152642412546"));
        param1.getParams().put("orgType", new Parameter("eq", (Object)4));
        param1.getParams().put("postNameNew", new Parameter("in", (Object)"\u526f\u7ecf\u7406\u7ea7,\u7ecf\u7406\u7ea7,\u603b\u52a9\u7ea7,\u526f\u603b\u7ea7"));
        CommonResponse iPageCommonResponse = this.baseUserApi.queryAllUserDataApi(param1);
        this.logger.info("\u4eba\u529b\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)iPageCommonResponse));
        if (iPageCommonResponse.getCode() == 0 && CollectionUtils.isNotEmpty((Collection)(records = (List)iPageCommonResponse.getData()))) {
            for (UserDataVO record : records) {
                LeaveRequestLeaderDTO leaveRequestLeaderDTO = new LeaveRequestLeaderDTO();
                leaveRequestLeaderDTO.setOrgSequence(Integer.valueOf(Integer.parseInt(record.getOrgSequence())));
                leaveRequestLeaderDTO.setDepartmentSequence(Integer.valueOf(Integer.parseInt(record.getDepartmentSequence())));
                leaveRequestLeaderDTO.setEmployeeSequence(Integer.valueOf(Integer.parseInt(record.getEmployeeSequence())));
                leaveRequestLeaderDTO.setUserName(record.getName());
                leaveRequestLeaderDTO.setState("\u6b63\u5e38");
                if (collect.containsKey(record.getName())) {
                    LeaveRequestEntity leaveRequestEntity = (LeaveRequestEntity)((Object)collect.get(record.getName()));
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    leaveRequestLeaderDTO.setDeptName(leaveRequestEntity.getDeptName());
                    leaveRequestLeaderDTO.setNewBegin(format.format(leaveRequestEntity.getNewBegin() * 1000L));
                    leaveRequestLeaderDTO.setNewEnd(format.format(leaveRequestEntity.getNewEnd() * 1000L));
                    leaveRequestLeaderDTO.setLeaveType(leaveRequestEntity.getLeaveType());
                    leaveRequestLeaderDTO.setMemo(leaveRequestEntity.getMemo());
                    leaveRequestLeaderDTO.setState("\u5916\u51fa\u4e2d");
                    leaveRequestLeaderDTO.setId(leaveRequestEntity.getId());
                }
                leaveRequestDTOS.add(leaveRequestLeaderDTO);
            }
        }
        Collections.sort(leaveRequestDTOS, (x, y) -> x.getEmployeeSequence() - y.getEmployeeSequence());
        Collections.sort(leaveRequestDTOS, (x, y) -> x.getDepartmentSequence() - y.getDepartmentSequence());
        Collections.sort(leaveRequestDTOS, (x, y) -> x.getOrgSequence() - y.getOrgSequence());
        Page pageData = new Page(1L, 50L, (long)leaveRequestDTOS.size());
        pageData.setRecords(leaveRequestDTOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    public static void main(String[] args) {
        ArrayList<LeaveRequestLeaderDTO> leaveRequestDTOS = new ArrayList<LeaveRequestLeaderDTO>();
        LeaveRequestLeaderDTO leaveRequestLeaderDTO = new LeaveRequestLeaderDTO();
        leaveRequestLeaderDTO.setId(Long.valueOf(1L));
        leaveRequestLeaderDTO.setEmployeeSequence(Integer.valueOf(2));
        leaveRequestDTOS.add(leaveRequestLeaderDTO);
        LeaveRequestLeaderDTO leaveRequestLeaderDTO1 = new LeaveRequestLeaderDTO();
        leaveRequestLeaderDTO1.setId(Long.valueOf(2L));
        leaveRequestLeaderDTO1.setEmployeeSequence(Integer.valueOf(1));
        leaveRequestDTOS.add(leaveRequestLeaderDTO1);
        LeaveRequestLeaderDTO leaveRequestLeaderDTO2 = new LeaveRequestLeaderDTO();
        leaveRequestLeaderDTO2.setId(Long.valueOf(3L));
        leaveRequestLeaderDTO2.setEmployeeSequence(Integer.valueOf(3));
        leaveRequestDTOS.add(leaveRequestLeaderDTO2);
        Collections.sort(leaveRequestDTOS, (x, y) -> x.getEmployeeSequence() - y.getEmployeeSequence());
        leaveRequestDTOS.forEach(a -> System.out.print(a.getEmployeeSequence()));
    }
}

