package com.ejianc.cfm.equipment.service.impl;

import com.ejianc.cfm.equipment.bean.EquipmentInEntity;
import com.ejianc.cfm.equipment.bean.EquipmentLedgerEntity;
import com.ejianc.cfm.equipment.bean.EquipmentStatusEntity;
import com.ejianc.cfm.equipment.enums.EquipStatusEnum;
import com.ejianc.cfm.equipment.service.IEquipmentLedgerService;
import com.ejianc.cfm.equipment.service.IEquipmentOutService;
import com.ejianc.cfm.equipment.service.IEquipmentStatusService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("equipmentStatus")
public class EquipmentStatusBpmServiceImpl implements ICommonBusinessService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IEquipmentLedgerService ledgerService;

    @Autowired
    private IEquipmentStatusService statusService;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    ;

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {

        EquipmentStatusEntity entity = statusService.selectById(billId);
        if (entity != null) {
            Long equipId = entity.getEquipId();
            if (equipId != null) {
                logger.info("更新设备状态开始--------------------");
                EquipmentLedgerEntity equipmentLedgerEntity = ledgerService.selectById(equipId);
                equipmentLedgerEntity.setEquipStatus(entity.getEquipStatus());
                equipmentLedgerEntity.setEquipStatusName((entity.getEquipStatusName()));
                ledgerService.saveOrUpdate(equipmentLedgerEntity);
                logger.info("更新设备状态结束--------------------{}更改为{}", equipmentLedgerEntity.getId(),entity.getEquipStatusName());
                return CommonResponse.success();
            }
        }

        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

}
