package com.ejianc.cfm.other.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 租赁公司-第三方位置信息
 * 
 * @author generator
 * 
 */
 @TableName("ejc_equipment_location")
public class LocationEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="create_user_name")
    private String createUserName; // 编制人
    @TableField(value="operator_id")
    private Long operatorId; // 经办人ID
    @TableField(value="operator_name")
    private String operatorName; // 经办人姓名
    @TableField(value="update_user_name")
    private String updateUserName; // 修改者
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value="equipment_code")
    private String equipmentCode; // 设备编号
    @TableField(value="locate_type")
    private String locateType; // 定位方式0为gps、1为基站、2为wifi
    @TableField(value="accuracy_type")
    /**
     * 当定位类型为gps时, 表示定位精度类型
     * 1：普通定位
     * 2：差分定位
     * 4：固定解定位
     * 5：浮点定位
     * 6：推算定位
     */
    private String accuracyType;

    @TableField(value="lng")
    private BigDecimal lng; // 经度
    @TableField(value="lat")
    private BigDecimal lat; // 维度
    @TableField(value="altitude")
    private BigDecimal altitude; // 海拔高度
    @TableField(value="speed")
    private Integer speed; // 速度
    @TableField(value="course")
    private Integer course; // 方向
    @TableField(value="locate_time")
    private Long locateTime; // 设备最后定位时间
    @TableField(value="gsm_signal")
    private Integer gsmSignal; // 设备当前信号值
    @TableField(value="bd_count")
    private Integer bdCount; // 设备当前接收到的北斗卫星数量
    @TableField(value="gps_count")
    private Integer gpsCount; // 设备当前接收到的gps卫星数量
    @TableField(value="step")
    private Integer step; // 当前运动步数(限计步设备)
    
    
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public String getEquipmentCode() {
        return equipmentCode;
    }

    public void setEquipmentCode(String equipmentCode) {
        this.equipmentCode = equipmentCode;
    }
    public String getLocateType() {
        return locateType;
    }

    public void setLocateType(String locateType) {
        this.locateType = locateType;
    }
    public String getAccuracyType() {
        return accuracyType;
    }

    public void setAccuracyType(String accuracyType) {
        this.accuracyType = accuracyType;
    }
    public BigDecimal getLng() {
        return lng;
    }

    public void setLng(BigDecimal lng) {
        this.lng = lng;
    }
    public BigDecimal getLat() {
        return lat;
    }

    public void setLat(BigDecimal lat) {
        this.lat = lat;
    }
    public BigDecimal getAltitude() {
        return altitude;
    }

    public void setAltitude(BigDecimal altitude) {
        this.altitude = altitude;
    }
    public Integer getSpeed() {
        return speed;
    }

    public void setSpeed(Integer speed) {
        this.speed = speed;
    }
    public Integer getCourse() {
        return course;
    }

    public void setCourse(Integer course) {
        this.course = course;
    }
    public Long getLocateTime() {
        return locateTime;
    }

    public void setLocateTime(Long locateTime) {
        this.locateTime = locateTime;
    }
    public Integer getGsmSignal() {
        return gsmSignal;
    }

    public void setGsmSignal(Integer gsmSignal) {
        this.gsmSignal = gsmSignal;
    }
    public Integer getBdCount() {
        return bdCount;
    }

    public void setBdCount(Integer bdCount) {
        this.bdCount = bdCount;
    }
    public Integer getGpsCount() {
        return gpsCount;
    }

    public void setGpsCount(Integer gpsCount) {
        this.gpsCount = gpsCount;
    }
    public Integer getStep() {
        return step;
    }

    public void setStep(Integer step) {
        this.step = step;
    }
    
}
