package com.ejianc.cfm.other.service;

import com.ejianc.cfm.other.vo.EquipInfoVO;
import com.ejianc.cfm.other.vo.LocationVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.cfm.other.bean.LocationEntity;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 租赁公司-第三方位置信息
 * 
 * @author generator
 * 
 */
public interface ILocationService extends IBaseService<LocationEntity> {

    /**
     * 获取用户下所有设备信息
     * @param userName
     * @return
     */
    List<EquipInfoVO> getAllEquipInfo(String userName);

    /**
     * 根据设备序列号获取位置信息
     * @param imeis
     * @return
     */
    List<LocationEntity> getAllLocationByImeis(List<String> imeis);

    /**
     * 根据设备编号获取最新位置信息
     * @param equipCode（即imei）
     * @return
     */
    LocationEntity getLatestLocationByEquipCode(String equipCode);
}
