package com.ejianc.cfm.other.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.cfm.other.service.OtherPublicService;
import com.ejianc.cfm.other.utils.SignUtil;
import com.ejianc.framework.cache.redis.CacheManager;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;

/**
 * 租赁公司-第三方调用公共方法
 *
 * @author generator
 */
@Service("OtherPublicService")
public class OtherPublicServiceImpl implements OtherPublicService {


    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private RedisTemplate<String,String> redisTemplate;

    @Autowired
    private CacheManager cacheManager;

    @Override
    public JSONObject getAuthorToken() {

        JSONObject queryParam = new JSONObject();
        String userName = "hongkun";
        String key = "5df12a08ca564d31afcb3e297257f2bd";
        Long timestamp = System.currentTimeMillis();

        JSONObject redisToken = cacheManager.get("equip::authorToken::" + userName);
        /**
         * 获取AutohorToken必要参数，默认5分钟有效期
         */
        if(redisToken != null){
            return redisToken;
        } else {
            String sign = SignUtil.sign(userName, key, timestamp.toString());
            queryParam.put("user", userName);
            queryParam.put("timestamp", timestamp);
            queryParam.put("sign", sign);
            logger.info("获取AuthorToken发送参数{}",queryParam.toJSONString());
            JSONObject tokenJSON = sendPostRequest("/open/auth/accessToken.do", queryParam);
            if(tokenJSON != null){
                logger.info("接收AuthorToken结果为{}",tokenJSON.toJSONString());
                String accessToken = tokenJSON.getJSONObject("result").getString("accessToken");
                queryParam.put("accessToken",accessToken);
                queryParam.put("userName",userName);
                cacheManager.setex("equip::authorToken::" + userName,queryParam,4*60);
                return queryParam;
            }
            logger.info("接收AuthorToken结果失败！");
            return null;
        }





    }


    @Override
    public JSONObject sendPostRequest(String queryUrl, JSONObject queryParam) {
        try {
            logger.info("查询业务api为"+queryUrl);
            logger.info("查询业务参数为"+queryParam.toJSONString());

            URL url = new URL("http://api.basegps.com:9088/chesafe" + queryUrl);
            HttpURLConnection connection = (HttpURLConnection) url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json; charset=utf-8");
            // 在Header中添加参数
//            connection.setRequestProperty("sign", sign);
            connection.setDoOutput(true);
            // 将JSON字符串作为请求体发送
            OutputStream outputStream = connection.getOutputStream();
            outputStream.write(queryParam.toString().getBytes());

            outputStream.flush();
            // 发送请求并获取响应
            int responseCode = connection.getResponseCode();

            // 检查响应是否成功
            if (responseCode == HttpURLConnection.HTTP_OK) {
                // 读取响应数据
                InputStream inputStream = connection.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                String line;
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                logger.info("调用接口查询结果为{}",response.toString());
                return JSONObject.parseObject(response.toString());
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}
