package com.ejianc.cfm.equipment.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * @author baipengyan
 * @date 2022/8/30
 * @description 归档状态
 */
public enum EquipStatusEnum {
	在用("1698618941133295617"),
	闲置("1698618978676510722"),
	停用("1698619012583264258"),
	在途("1698619043361067009"),
	待修缮("1698619107605221377"),
	报废("1698619157852983298");
	private final String code;

	EquipStatusEnum(String code) {
		this.code = code;
	}

	public static Object getNameByCode(String equipStatus) {
		switch (equipStatus) {
			case "1698618941133295617":
				return "在用";
			case "1698618978676510722":
				return "闲置";
			case "1698619012583264258":
				return "停用";
			case "1698619043361067009":
				return "在途";
			case "1698619107605221377":
				return "待修缮";
			case "1698619157852983298":
				return "报废";
			default:
				return equipStatus;
		}

	}
	public String getCode() {
		return code;
	}

	public static String getCodeByName(String name) {
		if (StringUtils.isBlank(name)) {
			return null;
		}
		for (EquipStatusEnum archiveStatusEnum : EquipStatusEnum.values()) {
			if (name.equals(archiveStatusEnum.toString())) {
				return archiveStatusEnum.getCode();
			}
		}
		return null;
	}
}
