package com.ejianc.cfm.equipment.service.impl;

import com.ejianc.cfm.equipment.bean.EquipRegisterEntity;
import com.ejianc.cfm.equipment.bean.EquipmentLedgerEntity;
import com.ejianc.cfm.equipment.service.IEquipRegisterService;
import com.ejianc.cfm.equipment.service.IEquipmentLedgerService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.Date;

@Service("equipRegister")
public class EquipRegisterBpmServiceImpl implements ICommonBusinessService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IEquipmentLedgerService ledgerService;

    @Autowired
    private IEquipRegisterService registerService;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    ;

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        logger.info("-------------推送设备台账开始");
        EquipRegisterEntity registerEntity = registerService.selectById(billId);
        EquipmentLedgerEntity map = BeanMapper.map(registerEntity, EquipmentLedgerEntity.class);
        Date date = new Date();
        map.setId(null);
        map.setBillCode(null);
        map.setCreateTime(date);
        map.setUpdateUserCode(null);
        map.setUpdateTime(null);
        map.setUpdateUserName(null);
        map.setSourceId(registerEntity.getId());

        boolean flag = ledgerService.saveOrUpdate(map);
        if (flag) {
            logger.info("-------------推送设备台账成功！");
            return CommonResponse.success("推送设备台账成功");
        } else {
            logger.info("-------------推送设备台账失败！");
            return CommonResponse.success("推送设备台账失败，请重新尝试!");
        }


    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

}
