package com.ejianc.cfm.other.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.cfm.other.vo.EquipInfoVO;
import com.ejianc.cfm.other.vo.LocationVO;
import com.ejianc.cfm.other.service.OtherPublicService;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.cfm.other.mapper.LocationMapper;
import com.ejianc.cfm.other.bean.LocationEntity;
import com.ejianc.cfm.other.service.ILocationService;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 租赁公司-第三方位置信息
 * 
 * @author generator
 * 
 */

@Service("locationService")

public class LocationServiceImpl extends BaseServiceImpl<LocationMapper, LocationEntity> implements ILocationService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private OtherPublicService otherPublicService;

    @Autowired
    private ILocationService locationService;

    void autoGetLocation(){
        logger.info("自动获取位置信息开始");
//        otherPublicService.sendPostRequest("")
    }

    @Override
    public List<EquipInfoVO> getAllEquipInfo(String userName) {
        String apiUrl = "/dinfo/allDevInfo.do";
        JSONObject queryParam = otherPublicService.getAuthorToken();
        JSONObject resultJSON = otherPublicService.sendPostRequest(apiUrl, queryParam);
        if(resultJSON != null){
            String retCode = resultJSON.getString("retCode");
            if(!"1".equals(retCode)){
                logger.info("调用接口失败，错误代码为---{}",retCode);
            } else {
                JSONArray result = resultJSON.getJSONArray("result");
                return result.toJavaList(EquipInfoVO.class);

            }

        }
        return null;
    }

    @Override
    public List<LocationEntity> getAllLocationByImeis(List<String> imeis) {
        String apiUrl = "/dpos/location.do";
        JSONObject queryParam = otherPublicService.getAuthorToken();
        List<LocationEntity> list = new ArrayList<>();
        for (String imei : imeis) {
            queryParam.put("imei",imei);
            JSONObject resultJSON = otherPublicService.sendPostRequest(apiUrl, queryParam);
            if(resultJSON != null){
                String retCode = resultJSON.getString("retCode");
                if(!"1".equals(retCode)){
                    logger.info("调用接口失败，错误代码为---{}",retCode);
                } else {
                    JSONObject result = resultJSON.getJSONObject("result");
                    LocationEntity locationEntity = result.toJavaObject(LocationEntity.class);
                    locationEntity.setEquipmentCode(imei);
                    list.add(locationEntity);

                }

            }
        }
        return list;

    }

    @Override
    public LocationEntity getLatestLocationByEquipCode(String equipCode) {
        LocationEntity locationEntity = locationService.getOne(Wrappers.<LocationEntity>lambdaQuery()
                .eq(LocationEntity::getEquipmentCode, equipCode)
                .orderByDesc(LocationEntity::getCreateTime)
                .last("limit 1")
        );
        return locationEntity;
    }
}
