/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.cfm.other.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.cfm.other.bean.LocationEntity;
import com.ejianc.cfm.other.mapper.LocationMapper;
import com.ejianc.cfm.other.service.ILocationService;
import com.ejianc.cfm.other.service.OtherPublicService;
import com.ejianc.cfm.other.vo.EquipInfoVO;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="locationService")
public class LocationServiceImpl
extends BaseServiceImpl<LocationMapper, LocationEntity>
implements ILocationService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private OtherPublicService otherPublicService;
    @Autowired
    private ILocationService locationService;

    void autoGetLocation() {
        this.logger.info("\u81ea\u52a8\u83b7\u53d6\u4f4d\u7f6e\u4fe1\u606f\u5f00\u59cb");
    }

    @Override
    public List<EquipInfoVO> getAllEquipInfo(String userName) {
        String apiUrl = "/dinfo/allDevInfo.do";
        JSONObject queryParam = this.otherPublicService.getAuthorToken();
        JSONObject resultJSON = this.otherPublicService.sendPostRequest(apiUrl, queryParam);
        if (resultJSON != null) {
            String retCode = resultJSON.getString("retCode");
            if (!"1".equals(retCode)) {
                this.logger.info("\u8c03\u7528\u63a5\u53e3\u5931\u8d25\uff0c\u9519\u8bef\u4ee3\u7801\u4e3a---{}", (Object)retCode);
            } else {
                JSONArray result = resultJSON.getJSONArray("result");
                return result.toJavaList(EquipInfoVO.class);
            }
        }
        return null;
    }

    @Override
    public List<LocationEntity> getAllLocationByImeis(List<String> imeis) {
        String apiUrl = "/dpos/location.do";
        JSONObject queryParam = this.otherPublicService.getAuthorToken();
        ArrayList<LocationEntity> list = new ArrayList<LocationEntity>();
        for (String imei : imeis) {
            queryParam.put("imei", (Object)imei);
            JSONObject resultJSON = this.otherPublicService.sendPostRequest(apiUrl, queryParam);
            if (resultJSON == null) continue;
            String retCode = resultJSON.getString("retCode");
            if (!"1".equals(retCode)) {
                this.logger.info("\u8c03\u7528\u63a5\u53e3\u5931\u8d25\uff0c\u9519\u8bef\u4ee3\u7801\u4e3a---{}", (Object)retCode);
                continue;
            }
            JSONObject result = resultJSON.getJSONObject("result");
            LocationEntity locationEntity = (LocationEntity)((Object)result.toJavaObject(LocationEntity.class));
            locationEntity.setEquipmentCode(imei);
            list.add(locationEntity);
        }
        return list;
    }

    @Override
    public LocationEntity getLatestLocationByEquipCode(String equipCode) {
        LocationEntity locationEntity = (LocationEntity)((Object)this.locationService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(LocationEntity::getEquipmentCode, (Object)equipCode)).orderByDesc(BaseEntity::getCreateTime)).last("limit 1")));
        return locationEntity;
    }
}

