package com.ejianc.business.equipment.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;

/**
 * <p>
 * 其他费用
 * </p>
 *
 * @author yqls
 * @since 2020-06-11
 */
@TableName("ejc_equipment_rent_use_record_fee")
public class RentUseRecordFeeVO extends BaseVO {

    private static final long serialVersionUID = 1L;

    /**
     * 使用记录主表主键
     */
    private Long useId;

    /**
     * 费用类型
     */
    private String feeType;

    /**
     * 金额
     */
    private BigDecimal money;
    
    /**
     * 金额含税
     */
    private BigDecimal moneyTax;
    
    /**
     * 税率
     */
    private BigDecimal taxRate;
    
    /**
     * 税金
     */
    private BigDecimal tax;

    /**
     * 备注
     */
    private String memo;
    private String useCode;
    private String sourceName;
    
    /**
     * 成本科目主键
     */
    private Long subjectId;

    /**
     * 成本科目名称
     */
    private String subjectName;

    /**
     * 成本科目集团主键
     */
    private Long orgSubjectId;
    
    /**
     * 核算对象主键
     */
    private Long accountingId;

    /**
     * 核算对象名称
     */
    private String accountingName;

    /**
     * 核算对象集团主键
     */
    private Long orgAccountingId;
    @ReferSerialTransfer(referCode="subject-project-ref")
    public Long getSubjectId() {
		return subjectId;
	}
    @ReferDeserialTransfer
	public void setSubjectId(Long subjectId) {
		this.subjectId = subjectId;
	}

	public String getSubjectName() {
		return subjectName;
	}

	public void setSubjectName(String subjectName) {
		this.subjectName = subjectName;
	}

	public Long getOrgSubjectId() {
		return orgSubjectId;
	}

	public void setOrgSubjectId(Long orgSubjectId) {
		this.orgSubjectId = orgSubjectId;
	}
	
	@ReferSerialTransfer(referCode="accounting-project-ref")
	public Long getAccountingId() {
		return accountingId;
	}
	@ReferDeserialTransfer
	public void setAccountingId(Long accountingId) {
		this.accountingId = accountingId;
	}
	public String getAccountingName() {
		return accountingName;
	}
	public void setAccountingName(String accountingName) {
		this.accountingName = accountingName;
	}
	public Long getOrgAccountingId() {
		return orgAccountingId;
	}
	public void setOrgAccountingId(Long orgAccountingId) {
		this.orgAccountingId = orgAccountingId;
	}
	public void setMoneyTax(BigDecimal moneyTax) {
		this.moneyTax = moneyTax;
	}

	public String getSourceName() {
        return sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public String getUseCode() {
        return useCode;
    }

    public void setUseCode(String useCode) {
        this.useCode = useCode;
    }

    public Long getUseId() {
        return useId;
    }

    public void setUseId(Long useId) {
        this.useId = useId;
    }
    public String getFeeType() {
        return feeType;
    }

    public void setFeeType(String feeType) {
        this.feeType = feeType;
    }
    public BigDecimal getMoney() {
        return money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

	public BigDecimal getMoneyTax() {
		return moneyTax;
	}

	public void setMoney_tax(BigDecimal moneyTax) {
		this.moneyTax = moneyTax;
	}

	public BigDecimal getTaxRate() {
		return taxRate;
	}

	public void setTaxRate(BigDecimal taxRate) {
		this.taxRate = taxRate;
	}

	public BigDecimal getTax() {
		return tax;
	}

	public void setTax(BigDecimal tax) {
		this.tax = tax;
	}


}
