/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.equipment.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.equipment.hystrix.EquipmentContractHystrix;
import com.ejianc.business.equipment.vo.EquipmentReportVo;
import com.ejianc.business.equipment.vo.PurchaseSettlementVO;
import com.ejianc.business.equipment.vo.RentUseRecordVO;
import com.ejianc.business.finance.pub.api.IPubContractApi;
import com.ejianc.business.tax.vo.ContractResVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@FeignClient(name="ejc-equipment-web", url="${common.env.feign-client-url}", path="ejc-equipment-web", fallback=EquipmentContractHystrix.class)
public interface IEquipmentContractApi
extends IPubContractApi {
    @PostMapping(value={"/api/equipment/getContract"})
    public CommonResponse<JSONObject> getContract(@RequestBody QueryParam var1);

    @PostMapping(value={"/api/equipment/getContractSettle"})
    public CommonResponse<JSONObject> getContractSettle(@RequestBody QueryParam var1);

    @PostMapping(value={"/api/equipment/getRentSettle"})
    public CommonResponse<JSONObject> getRentSettle(@RequestBody QueryParam var1);

    @GetMapping(value={"/api/equipment/updatePurchaseContractSumPayMny"})
    public CommonResponse<String> updatePurchaseContractSumPayMny(@RequestParam(value="contractId", required=true) Long var1, @RequestParam(value="payMny") BigDecimal var2, @RequestParam(value="prepayMny") BigDecimal var3);

    @GetMapping(value={"/api/equipment/updateRentContractSumPayMny"})
    public CommonResponse<String> updateRentContractSumPayMny(@RequestParam(value="contractId", required=true) Long var1, @RequestParam(value="payMny") BigDecimal var2, @RequestParam(value="prepayMny") BigDecimal var3);

    @GetMapping(value={"/api/equipment/updatePurchaseSettleSumPayMny"})
    public CommonResponse<String> updatePurchaseSettleSumPayMny(@RequestParam(value="settleId", required=true) Long var1, @RequestParam(value="payMny") BigDecimal var2);

    @GetMapping(value={"/api/equipment/updateRentSettleSumPayMny"})
    public CommonResponse<String> updateRentSettleSumPayMny(@RequestParam(value="settleId", required=true) Long var1, @RequestParam(value="payMny") BigDecimal var2);

    @GetMapping(value={"/api/equipment/updatePurchaseSettleSumApplyMny"})
    public CommonResponse<String> updatePurchaseSettleSumApplyMny(@RequestParam(value="settleId", required=true) Long var1, @RequestParam(value="applyMny") BigDecimal var2);

    @GetMapping(value={"/api/equipment/updateRentSettleSumApplyMny"})
    public CommonResponse<String> updateRentSettleSumApplyMny(@RequestParam(value="settleId", required=true) Long var1, @RequestParam(value="applyMny") BigDecimal var2);

    @PostMapping(value={"/api/equipment/afterApproveInvoiceReceive"})
    public CommonResponse<String> afterApproveInvoiceReceive(@RequestParam(value="contractId", required=true) Long var1, @RequestParam(value="invoiceMny") BigDecimal var2, @RequestParam(value="invoiceTaxMny") BigDecimal var3);

    @PostMapping(value={"/api/equipment/afterRevocationInvoiceReceive"})
    public CommonResponse<JSONObject> afterRevocationInvoiceReceive(@RequestParam(value="contractId", required=true) Long var1, @RequestParam(value="invoiceMny") BigDecimal var2, @RequestParam(value="invoiceTaxMny") BigDecimal var3);

    @PostMapping(value={"/api/equipment/getPurchaseContractById"})
    public CommonResponse<ContractResVO> getContractById(@RequestParam(value="contractId", required=true) Long var1);

    @PostMapping(value={"/api/equipment/rentAfterApproveInvoiceReceive"})
    public CommonResponse<String> rentAfterApproveInvoiceReceive(@RequestParam(value="contractId", required=true) Long var1, @RequestParam(value="invoiceMny") BigDecimal var2, @RequestParam(value="invoiceTaxMny") BigDecimal var3);

    @PostMapping(value={"/api/equipment/rentAfterRevocationInvoiceReceive"})
    public CommonResponse<JSONObject> rentAfterRevocationInvoiceReceive(@RequestParam(value="contractId", required=true) Long var1, @RequestParam(value="invoiceMny") BigDecimal var2, @RequestParam(value="invoiceTaxMny") BigDecimal var3);

    @RequestMapping(value={"/api/equipment/getMonthEquipmentMny"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<EquipmentReportVo>> getMonthEquipmentMny(@RequestParam(value="projectId") Long var1, @RequestParam(value="lastDay") Integer var2);

    @RequestMapping(value={"/api/equipment/getEquipment"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<EquipmentReportVo>> getEquipment(@RequestParam(value="projectId") Long var1);

    @PostMapping(value={"/api/equipment/updateRentUseRecordSporadicUseFlag"})
    public CommonResponse<String> updateRentUseRecordSporadicUseFlag(@RequestBody List<RentUseRecordVO> var1);

    @GetMapping(value={"/api/equipment/getSumSettleTaxMny"})
    public CommonResponse<PurchaseSettlementVO> getSumSettleTaxMny(@RequestParam(value="contractId", required=true) Long var1, @RequestParam(value="projectId", required=true) Long var2);
}

