package com.ejianc.business.equipment.api;

import com.ejianc.business.equipment.hystrix.SettlementHystrix;
import com.ejianc.business.equipment.vo.SettlementVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 获取合同参照工厂类方法
 * 
 * @author yqls
 *
 */
@FeignClient(name= "ejc-equipment-web", url="${common.env.feign-client-url}", path="ejc-equipment-web", fallback = SettlementHystrix.class)
public interface ISettlementApi {
	/**
	 * 根据条件查询结算单累计冲抵金额
	 * @return
	 */
	@PostMapping(value = "/api/equipment/getPurchaseSettlementById")
	public CommonResponse<SettlementVO> getPurchaseSettlementById(@RequestParam(value = "contractId", required = true) Long contractId, @RequestParam(value = "orgId", required = true) Long orgId);
	/**
	 * 根据条件查询结算单累计冲抵金额
	 * @return
	 */
	@PostMapping(value = "/api/equipment/getRentSettlementById")
	public CommonResponse<SettlementVO> getRentSettlementById(@RequestParam(value = "contractId", required = true) Long contractId, @RequestParam(value = "orgId", required = true) Long orgId);
}
