/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.equipment.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.equipment.bean.ApplyDetailEntity;
import com.ejianc.business.equipment.bean.ApplyEntity;
import com.ejianc.business.equipment.mapper.ApplyMapper;
import com.ejianc.business.equipment.service.IApplyService;
import com.ejianc.business.equipment.vo.ApplyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ApplyService")
public class ApplyServiceImpl
extends BaseServiceImpl<ApplyMapper, ApplyEntity>
implements IApplyService {
    private static final String EQUIPMENT_APPLY_BILL_CODE = "EQUIPMENT_APPLY";
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    public CommonResponse<ApplyVO> saveOrUpdate(ApplyVO applyVo) {
        List entities;
        LambdaQueryWrapper lambda;
        Long tenantId = InvocationInfoProxy.getTenantid();
        ApplyEntity entity = null;
        Object operateType = null;
        if (StringUtils.isEmpty((CharSequence)applyVo.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(EQUIPMENT_APPLY_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                applyVo.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (applyVo.getId() != null && applyVo.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(ApplyEntity::getBillCode, (Object)applyVo.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)applyVo.getId());
            entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(ApplyEntity::getBillCode, (Object)applyVo.getBillCode());
            entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
        }
        entity = (ApplyEntity)((Object)BeanMapper.map((Object)applyVo, ApplyEntity.class));
        entity.setDr(0);
        List<ApplyDetailEntity> applyDetail = entity.getApplyDetail();
        String equipmentName = "";
        if (applyDetail != null && applyDetail.size() > 0) {
            for (ApplyDetailEntity applyDetailEntity : applyDetail) {
                equipmentName = equipmentName + applyDetailEntity.getName() + ",";
            }
            String substring = equipmentName.substring(0, equipmentName.length() - 1);
            entity.setEquipmentName(substring);
        }
        super.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), ApplyVO.class));
    }

    @Override
    public ApplyVO queryDetail(Long id) {
        ApplyEntity entity = (ApplyEntity)((Object)super.selectById((Serializable)id));
        ApplyVO applyVo = (ApplyVO)BeanMapper.map((Object)((Object)entity), ApplyVO.class);
        return applyVo;
    }

    @Override
    public void deleteApply(List<ApplyVO> vos) {
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), false);
    }

    @Override
    public List<ApplyVO> applyTree() {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        List list = super.list((Wrapper)lambda);
        List applyVOList = BeanMapper.mapList((Iterable)list, ApplyVO.class);
        for (ApplyVO applyVo : applyVOList) {
            applyVo.setName(applyVo.getBillCode() + applyVo.getPlanDate());
        }
        return applyVOList;
    }

    @Override
    public List<ApplyVO> queryListTree(Map<String, Object> params) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        if (params.get("signDate") != null) {
            lambda.le(ApplyEntity::getPlanDate, params.get("signDate"));
        }
        if (params.get("projectId") != null) {
            lambda.eq(ApplyEntity::getProjectId, params.get("projectId"));
        }
        if (params.get("orgId") != null) {
            Long orgId = Long.valueOf(params.get("orgId").toString());
            lambda.in(ApplyEntity::getOrgId, (Collection)((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        lambda.in(ApplyEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        lambda.orderByDesc(BaseEntity::getCreateTime);
        List dataList = super.list((Wrapper)lambda);
        if (dataList != null && dataList.size() > 0) {
            return BeanMapper.mapList((Iterable)dataList, ApplyVO.class);
        }
        return null;
    }
}

