package com.ejianc.business.equipment.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;

/**
 * <p>
 * 设备明细
 * </p>
 *
 * @author sunyj
 * @since 2020-06-04
 */
@TableName("ejc_equipment_purchase_settlement_detail")
public class PurchaseSettlementDetailEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 结算表主键
     */
    @TableField("settlement_id")
    private Long settlementId;

    /**
     * 设备档案主键
     */
    @TableField("equipment_id")
    private Long equipmentId;

    /**
     * 合同明细主键
     */
    @TableField("contract_detail_id")
    private Long contractDetailId;

    /**
     * 来源类型 1-设备档案，2-合同
     */
    @TableField("source")
    private Integer source;

    /**
     * 设备编码
     */
    @TableField("code")
    private String code;

    /**
     * 设备名称
     */
    @TableField("name")
    private String name;

    /**
     * 规格型号
     */
    @TableField("spec")
    private String spec;

    /**
     * 计量单位名称
     */
    @TableField("unit_name")
    private String unitName;

    /**
     * 单价
     */
    @TableField("price")
    private BigDecimal price;

    /**
     * 数量
     */
    @TableField("num")
    private BigDecimal num;

    /**
     * 金额
     */
    @TableField("money")
    private BigDecimal money;

    /**
     * 本期结算金额
     */
    @TableField("settlement_mny")
    private BigDecimal settlementMny;

    /**
     * 备注
     */
    @TableField("memo")
    private String memo;
    /**
     * 成本科目主键
     */
    @TableField(value = "subject_id")
    private Long subjectId;
    /**
     * 成本科目名称
     */
    @TableField("subject_name")
    private String subjectName;

    /**
     * 成本科目集团主键
     */
    @TableField(value = "org_subject_id")
    private Long orgSubjectId;

    /**
     * 单价(含税)
     */
    @TableField("tax_price")
    private BigDecimal taxPrice;

    /**
     * 税率
     */
    @TableField("detai_tax_rate")
    private BigDecimal detaiTaxRate;

    /**
     * 金额（含税）
     */
    @TableField("tax_money")
    private BigDecimal taxMoney;

    /**
     * 税额
     */
    @TableField("tax")
    private BigDecimal tax;

    /**
     * 本期结算金额
     */
    @TableField("settlement_tax_mny")
    private BigDecimal settlementTaxMny;

    /**
     * 核算对象主键
     */
    @TableField(value = "accounting_id")
    private Long accountingId;

    /**
     * 核算对象名称
     */
    @TableField(value = "accounting_name")
    private String accountingName;

    /**
     * 核算对象集团主键
     */
    @TableField(value = "org_accounting_id")
    private Long orgAccountingId;


    public BigDecimal getSettlementTaxMny() {
        return settlementTaxMny;
    }

    public void setSettlementTaxMny(BigDecimal settlementTaxMny) {
        this.settlementTaxMny = settlementTaxMny;
    }

    public BigDecimal getTaxPrice() {
        return taxPrice;
    }

    public void setTaxPrice(BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }

    public BigDecimal getDetaiTaxRate() {
        return detaiTaxRate;
    }

    public void setDetaiTaxRate(BigDecimal detaiTaxRate) {
        this.detaiTaxRate = detaiTaxRate;
    }

    public BigDecimal getTaxMoney() {
        return taxMoney;
    }

    public void setTaxMoney(BigDecimal taxMoney) {
        this.taxMoney = taxMoney;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public Long getSettlementId() {
        return settlementId;
    }

    public void setSettlementId(Long settlementId) {
        this.settlementId = settlementId;
    }

    public Long getEquipmentId() {
        return equipmentId;
    }

    public void setEquipmentId(Long equipmentId) {
        this.equipmentId = equipmentId;
    }

    public Long getContractDetailId() {
        return contractDetailId;
    }

    public void setContractDetailId(Long contractDetailId) {
        this.contractDetailId = contractDetailId;
    }

    public Integer getSource() {
        return source;
    }

    public void setSource(Integer source) {
        this.source = source;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }

    public BigDecimal getMoney() {
        return money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }

    public BigDecimal getSettlementMny() {
        return settlementMny;
    }

    public void setSettlementMny(BigDecimal settlementMny) {
        this.settlementMny = settlementMny;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getSubjectId() {
        return subjectId;
    }

    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public Long getOrgSubjectId() {
        return orgSubjectId;
    }

    public void setOrgSubjectId(Long orgSubjectId) {
        this.orgSubjectId = orgSubjectId;
    }

    public Long getAccountingId() {
        return accountingId;
    }

    public void setAccountingId(Long accountingId) {
        this.accountingId = accountingId;
    }

    public String getAccountingName() {
        return accountingName;
    }

    public void setAccountingName(String accountingName) {
        this.accountingName = accountingName;
    }

    public Long getOrgAccountingId() {
        return orgAccountingId;
    }

    public void setOrgAccountingId(Long orgAccountingId) {
        this.orgAccountingId = orgAccountingId;
    }
}
