package com.ejianc.business.equipment.bean;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 补充协议租赁合同明细
 * 
 * @author generator
 * 
 */
 @TableName("ejc_equipment_rent_contract_detail")
public class SupplementRentContractDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="contract_id")
    private java.lang.Long contractId; // 合同主键
    @TableField(value="equipment_id")
    private java.lang.Long equipmentId; // 设备档案主键
    @TableField(value="apply_id")
    private java.lang.Long applyId; // 设备申请主键
    @TableField(value="apply_detail_id")
    private java.lang.Long applyDetailId; // 设备申请子表主键
    @TableField(value="code")
    private java.lang.String code; // 设备编码
    @TableField(value="name")
    private java.lang.String name; // 设备名称
    @TableField(value="spec")
    private java.lang.String spec; // 规格型号
    @TableField(value="charge_type")
    private java.lang.String chargeType; // 计费方式
    @TableField(value="unit_name")
    private java.lang.String unitName; // 计量单位
    /**
     * 起租时间
     */
    @TableField("start_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate;

    /**
     * 停租时间
     */
    @TableField("end_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate;
    @TableField(value="rent_term")
    private java.lang.String rentTerm; // 租期
    @TableField(value="price")
    private java.math.BigDecimal price; // 单价
    @TableField(value="num")
    private java.math.BigDecimal num; // 数量
    @TableField(value="money")
    private java.math.BigDecimal money; // 金额
    @TableField(value="memo")
    private java.lang.String memo; // 备注
    @TableField(value="change_id")
    private java.lang.Long changeId; // 变更主键
    @TableField(value="change_bid")
    private java.lang.Long changeBid; // 变更子表主键
    @TableField(value="change_type")
    private java.lang.String changeType; // 变更类型
    @TableField(value="source")
    private java.lang.Integer source; // 来源类型 1-设备档案，2-申请单
    @TableField(value="src_supplement_flag")
    private java.lang.Integer srcSupplementFlag; // 是否来源补充协议(1:是，0：否)
    @TableField(value="src_supplement_id")
    private java.lang.Long srcSupplementId; // 来源补充协议主表ID
    @TableField(value="src_supplement_detail_id")
    private java.lang.Long srcSupplementDetailId; // 来源补充协议明细ID


    /**
     * 单价(含税)
     */
    @TableField("tax_price")
    private BigDecimal taxPrice;

    /**
     * 税率
     */
    @TableField("detai_tax_rate")
    private BigDecimal detaiTaxRate;

    /**
     * 金额（含税）
     */
    @TableField("tax_money")
    private BigDecimal taxMoney;

    /**
     * 税额
     */
    @TableField("tax")
    private BigDecimal tax;

    public BigDecimal getTaxPrice() {
        return taxPrice;
    }

    public void setTaxPrice(BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }

    public BigDecimal getDetaiTaxRate() {
        return detaiTaxRate;
    }

    public void setDetaiTaxRate(BigDecimal detaiTaxRate) {
        this.detaiTaxRate = detaiTaxRate;
    }

    public BigDecimal getTaxMoney() {
        return taxMoney;
    }

    public void setTaxMoney(BigDecimal taxMoney) {
        this.taxMoney = taxMoney;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    /**
     * 合同主键
     */
    public java.lang.Long getContractId() {
        return contractId;
    }

    /**
     * 合同主键
     */
    public void setContractId(java.lang.Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 设备档案主键
     */
    public java.lang.Long getEquipmentId() {
        return equipmentId;
    }

    /**
     * 设备档案主键
     */
    public void setEquipmentId(java.lang.Long equipmentId) {
        this.equipmentId = equipmentId;
    }
    /**
     * 设备申请主键
     */
    public java.lang.Long getApplyId() {
        return applyId;
    }

    /**
     * 设备申请主键
     */
    public void setApplyId(java.lang.Long applyId) {
        this.applyId = applyId;
    }
    /**
     * 设备申请子表主键
     */
    public java.lang.Long getApplyDetailId() {
        return applyDetailId;
    }

    /**
     * 设备申请子表主键
     */
    public void setApplyDetailId(java.lang.Long applyDetailId) {
        this.applyDetailId = applyDetailId;
    }
    /**
     * 设备编码
     */
    public java.lang.String getCode() {
        return code;
    }

    /**
     * 设备编码
     */
    public void setCode(java.lang.String code) {
        this.code = code;
    }
    /**
     * 设备名称
     */
    public java.lang.String getName() {
        return name;
    }

    /**
     * 设备名称
     */
    public void setName(java.lang.String name) {
        this.name = name;
    }
    /**
     * 规格型号
     */
    public java.lang.String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(java.lang.String spec) {
        this.spec = spec;
    }
    /**
     * 计费方式
     */
    public java.lang.String getChargeType() {
        return chargeType;
    }

    /**
     * 计费方式
     */
    public void setChargeType(java.lang.String chargeType) {
        this.chargeType = chargeType;
    }
    /**
     * 计量单位
     */
    public java.lang.String getUnitName() {
        return unitName;
    }

    /**
     * 计量单位
     */
    public void setUnitName(java.lang.String unitName) {
        this.unitName = unitName;
    }
    /**
     * 起租时间
     */
    public java.util.Date getStartDate() {
        return startDate;
    }

    /**
     * 起租时间
     */
    public void setStartDate(java.util.Date startDate) {
        this.startDate = startDate;
    }
    /**
     * 停租时间
     */
    public java.util.Date getEndDate() {
        return endDate;
    }

    /**
     * 停租时间
     */
    public void setEndDate(java.util.Date endDate) {
        this.endDate = endDate;
    }
    /**
     * 租期
     */
    public java.lang.String getRentTerm() {
        return rentTerm;
    }

    /**
     * 租期
     */
    public void setRentTerm(java.lang.String rentTerm) {
        this.rentTerm = rentTerm;
    }
    /**
     * 单价
     */
    public java.math.BigDecimal getPrice() {
        return price;
    }

    /**
     * 单价
     */
    public void setPrice(java.math.BigDecimal price) {
        this.price = price;
    }
    /**
     * 数量
     */
    public java.math.BigDecimal getNum() {
        return num;
    }

    /**
     * 数量
     */
    public void setNum(java.math.BigDecimal num) {
        this.num = num;
    }
    /**
     * 金额
     */
    public java.math.BigDecimal getMoney() {
        return money;
    }

    /**
     * 金额
     */
    public void setMoney(java.math.BigDecimal money) {
        this.money = money;
    }
    /**
     * 备注
     */
    public java.lang.String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(java.lang.String memo) {
        this.memo = memo;
    }
    /**
     * 变更主键
     */
    public java.lang.Long getChangeId() {
        return changeId;
    }

    /**
     * 变更主键
     */
    public void setChangeId(java.lang.Long changeId) {
        this.changeId = changeId;
    }
    /**
     * 变更子表主键
     */
    public java.lang.Long getChangeBid() {
        return changeBid;
    }

    /**
     * 变更子表主键
     */
    public void setChangeBid(java.lang.Long changeBid) {
        this.changeBid = changeBid;
    }
    /**
     * 变更类型
     */
    public java.lang.String getChangeType() {
        return changeType;
    }

    /**
     * 变更类型
     */
    public void setChangeType(java.lang.String changeType) {
        this.changeType = changeType;
    }
    /**
     * 来源类型 1-设备档案，2-申请单
     */
    public java.lang.Integer getSource() {
        return source;
    }

    /**
     * 来源类型 1-设备档案，2-申请单
     */
    public void setSource(java.lang.Integer source) {
        this.source = source;
    }
    /**
     * 是否来源补充协议(1:是，0：否)
     */
    public java.lang.Integer getSrcSupplementFlag() {
        return srcSupplementFlag;
    }

    /**
     * 是否来源补充协议(1:是，0：否)
     */
    public void setSrcSupplementFlag(java.lang.Integer srcSupplementFlag) {
        this.srcSupplementFlag = srcSupplementFlag;
    }
    /**
     * 来源补充协议主表ID
     */
    public java.lang.Long getSrcSupplementId() {
        return srcSupplementId;
    }

    /**
     * 来源补充协议主表ID
     */
    public void setSrcSupplementId(java.lang.Long srcSupplementId) {
        this.srcSupplementId = srcSupplementId;
    }
    /**
     * 来源补充协议明细ID
     */
    public java.lang.Long getSrcSupplementDetailId() {
        return srcSupplementDetailId;
    }

    /**
     * 来源补充协议明细ID
     */
    public void setSrcSupplementDetailId(java.lang.Long srcSupplementDetailId) {
        this.srcSupplementDetailId = srcSupplementDetailId;
    }
    
}
