package com.ejianc.business.equipment.bean;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.equipment.bean.SupplementRentContractDetailEntity;
import com.ejianc.business.equipment.bean.SupplementRentContractClauseEntity;
import com.ejianc.business.equipment.bean.SupplementRentContractFeeEntity;
import com.ejianc.business.equipment.bean.SupplementRentContractStageEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 设备租赁合同补充协议
 * 
 * @author generator
 * 
 */
 @TableName("ejc_equipment_rent_contract")
public class SupplementRentContractEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 合同编码
     */
    @TableField("bill_code")
    private String billCode;

    /**
     * 组织主键
     */
    @TableField("org_id")
    private Long orgId;

    /**
     * 组织名称
     */
    @TableField("org_name")
    private String orgName;

    /**
     * 所属组织(采购组织)
     */
    @TableField("purchase_org_id")
    private Long purchaseOrgId;

    /**
     * 所属组织名称(采购组织)
     */
    @TableField("purchase_org_name")
    private String purchaseOrgName;

    /**
     * 项目主键
     */
    @TableField("project_id")
    private Long projectId;

    /**
     * 项目名称
     */
    @TableField("project_name")
    private String projectName;

    /**
     * 总包企业主键
     */
    @TableField("customer_id")
    private Long customerId;

    /**
     * 总包企业名称
     */
    @TableField("customer_name")
    private String customerName;

    /**
     * 设备供应商主键
     */
    @TableField("supplier_id")
    private Long supplierId;

    /**
     * 设备供应商名称
     */
    @TableField("supplier_name")
    private String supplierName;

    /**
     * 签约日期
     */
    @TableField("sign_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate;

    /**
     * 合同税率
     */
    @TableField("tax_rate")
    private BigDecimal taxRate;

    /**
     * 合同支付比例
     */
    @TableField("pay_scale")
    private BigDecimal payScale;

    /**
     * 经办人
     */
    @TableField("employee_id")
    private Long employeeId;
    /**
     * 经办人名称
     */
    @TableField("employee_name")
    private String employeeName;


    /**
     * 合同状态：1-履约, 2-中止，3-终止，4-废除，5-封账
     */
    @TableField("contract_status")
    private String contractStatus;

    /**
     * 备注
     */
    @TableField("memo")
    private String memo;

    /**
     * 合同金额(含税)
     */
    @TableField("contract_tax_mny")
    private BigDecimal contractTaxMny;

    /**
     * 税金
     */
    @TableField("tax_mny")
    private BigDecimal taxMny;

    /**
     * 合同金额(不含税)
     */
    @TableField("contract_mny")
    private BigDecimal contractMny;

    /**
     * 单据状态（审批必须字段）
     */
    @TableField("bill_state")
    private Integer billState;

    /**
     * 变更版本
     */
    @TableField("change_version")
    private Integer changeVersion;

    /**
     * 变更主键
     */
    @TableField("change_id")
    private Long changeId;

    /**
     * 变更编号
     */
    @TableField("change_code")
    private String changeCode;

    /**
     * 初始版本金额（不含税）
     */
    @TableField("base_money")
    private BigDecimal baseMoney;

    /**
     * 初始版本金额
     */
    @TableField("base_tax_money")
    private BigDecimal baseTaxMoney;

    /**
     * 变更前金额（不含税）
     */
    @TableField("before_change_mny")
    private BigDecimal beforeChangeMny;

    /**
     * 变更前金额
     */
    @TableField("before_change_tax_mny")
    private BigDecimal beforeChangeTaxMny;

    /**
     * 变更中金额(不含税)
     */
    @TableField("changing_mny")
    private BigDecimal changingMny;

    /**
     * 变更中金额
     */
    @TableField("changing_tax_mny")
    private BigDecimal changingTaxMny;

    /**
     * 变更状态1-未变更 2-变更中 3-已变更
     */
    @TableField("change_status")
    private Integer changeStatus;

    /**
     * 累计预付款金额
     */
    @TableField("sum_prepay_mny")
    private BigDecimal sumPrepayMny;

    /**
     * 累计付款金额
     */
    @TableField("sum_pay_mny")
    private BigDecimal sumPayMny;

    /**
     * 累计冲抵金额
     */
    @TableField("sum_offset_mny")
    private BigDecimal sumOffsetMny;

    /**
     * 累计结算金额(不含税)
     */
    @TableField("sum_settlement_mny")
    private BigDecimal sumSettlementMny;

    /**
     * 累计结算金额
     */
    @TableField("sum_settlement_tax_mny")
    private BigDecimal sumSettlementTaxMny;

    /**
     * 累计收票金额(不含税)
     */
    @TableField("sum_invoice_mny")
    private BigDecimal sumInvoiceMny;

    /**
     * 累计收票金额
     */
    @TableField("sum_invoice_tax_mny")
    private BigDecimal sumInvoiceTaxMny;
    /**
     * 合同名称
     */
    @TableField("contract_name")
    private String contractName;

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getBillCode() {
        return billCode;
    }
    // 设备明细子表
    @TableField(exist = false)
    @SubEntity(serviceName="supplementRentContractDetailService",pidName = "contractId")
    private List<SupplementRentContractDetailEntity> rentdetail = new ArrayList<>();

    // 合同条款子表
    @TableField(exist = false)
    @SubEntity(serviceName="supplementRentContractClauseService",pidName = "contractId")
    private List<SupplementRentContractClauseEntity> rentclause = new ArrayList<>();

    // 其他费用子表
    @TableField(exist = false)
    @SubEntity(serviceName="supplementRentContractFeeService",pidName = "contractId")
    private List<SupplementRentContractFeeEntity> rentfee = new ArrayList<>();

    // 付款阶段子表
    @TableField(exist = false)
    @SubEntity(serviceName="supplementRentContractStageService",pidName = "contractId")
    private List<SupplementRentContractStageEntity> rentstage = new ArrayList<>();

    /**
     * 结算类型(0:过程结算，1:最终结算)
     */
    @TableField("settlement_type")
    private Integer settlementType;

    @TableField(value="main_contract_id")
    private Long mainContractId; // 主合同ID
    @TableField(value="main_contract_code")
    private String mainContractCode; // 主合同编码
    @TableField(value="main_contract_name")
    private String mainContractName; // 主合同编码
    @TableField(value="supplement_flag")
    private Integer supplementFlag; // 是否补充协议(1:是，0：否)
    @TableField(value="replace_sign_flag")
    private Integer replaceSignFlag; // 是否代签：0-否，1-是

    public Integer getReplaceSignFlag() {
        return replaceSignFlag;
    }

    public void setReplaceSignFlag(Integer replaceSignFlag) {
        this.replaceSignFlag = replaceSignFlag;
    }

    public Long getMainContractId() {
        return mainContractId;
    }

    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }

    public String getMainContractCode() {
        return mainContractCode;
    }

    public void setMainContractCode(String mainContractCode) {
        this.mainContractCode = mainContractCode;
    }

    public String getMainContractName() {
        return mainContractName;
    }

    public void setMainContractName(String mainContractName) {
        this.mainContractName = mainContractName;
    }

    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }

    public Integer getSettlementType() {
        return settlementType;
    }

    public void setSettlementType(Integer settlementType) {
        this.settlementType = settlementType;
    }

    public List<SupplementRentContractDetailEntity> getRentdetail() {
        return rentdetail;
    }

    public void setRentdetail(List<SupplementRentContractDetailEntity> rentdetail) {
        this.rentdetail = rentdetail;
    }

    public List<SupplementRentContractClauseEntity> getRentclause() {
        return rentclause;
    }

    public void setRentclause(List<SupplementRentContractClauseEntity> rentclause) {
        this.rentclause = rentclause;
    }

    public List<SupplementRentContractFeeEntity> getRentfee() {
        return rentfee;
    }

    public void setRentfee(List<SupplementRentContractFeeEntity> rentfee) {
        this.rentfee = rentfee;
    }

    public List<SupplementRentContractStageEntity> getRentstage() {
        return rentstage;
    }

    public void setRentstage(List<SupplementRentContractStageEntity> rentstage) {
        this.rentstage = rentstage;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getPurchaseOrgId() {
        return purchaseOrgId;
    }

    public void setPurchaseOrgId(Long purchaseOrgId) {
        this.purchaseOrgId = purchaseOrgId;
    }

    public String getPurchaseOrgName() {
        return purchaseOrgName;
    }

    public void setPurchaseOrgName(String purchaseOrgName) {
        this.purchaseOrgName = purchaseOrgName;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public BigDecimal getPayScale() {
        return payScale;
    }

    public void setPayScale(BigDecimal payScale) {
        this.payScale = payScale;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getContractStatus() {
        return contractStatus;
    }

    public void setContractStatus(String contractStatus) {
        this.contractStatus = contractStatus;
    }

    public String getMemo() {
        return memo;

    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }
    public BigDecimal getBaseMoney() {
        return baseMoney;
    }

    public void setBaseMoney(BigDecimal baseMoney) {
        this.baseMoney = baseMoney;
    }
    public BigDecimal getBaseTaxMoney() {
        return baseTaxMoney;
    }

    public void setBaseTaxMoney(BigDecimal baseTaxMoney) {
        this.baseTaxMoney = baseTaxMoney;
    }
    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }
    public BigDecimal getBeforeChangeTaxMny() {
        return beforeChangeTaxMny;
    }

    public void setBeforeChangeTaxMny(BigDecimal beforeChangeTaxMny) {
        this.beforeChangeTaxMny = beforeChangeTaxMny;
    }
    public BigDecimal getChangingMny() {
        return changingMny;
    }

    public void setChangingMny(BigDecimal changingMny) {
        this.changingMny = changingMny;
    }
    public BigDecimal getChangingTaxMny() {
        return changingTaxMny;
    }

    public void setChangingTaxMny(BigDecimal changingTaxMny) {
        this.changingTaxMny = changingTaxMny;
    }
    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }
    public BigDecimal getSumPrepayMny() {
        return sumPrepayMny;
    }

    public void setSumPrepayMny(BigDecimal sumPrepayMny) {
        this.sumPrepayMny = sumPrepayMny;
    }
    public BigDecimal getSumPayMny() {
        return sumPayMny;
    }

    public void setSumPayMny(BigDecimal sumPayMny) {
        this.sumPayMny = sumPayMny;
    }
    public BigDecimal getSumOffsetMny() {
        return sumOffsetMny;
    }

    public void setSumOffsetMny(BigDecimal sumOffsetMny) {
        this.sumOffsetMny = sumOffsetMny;
    }
    public BigDecimal getSumSettlementMny() {
        return sumSettlementMny;
    }

    public void setSumSettlementMny(BigDecimal sumSettlementMny) {
        this.sumSettlementMny = sumSettlementMny;
    }
    public BigDecimal getSumSettlementTaxMny() {
        return sumSettlementTaxMny;
    }

    public void setSumSettlementTaxMny(BigDecimal sumSettlementTaxMny) {
        this.sumSettlementTaxMny = sumSettlementTaxMny;
    }
    public BigDecimal getSumInvoiceMny() {
        return sumInvoiceMny;
    }

    public void setSumInvoiceMny(BigDecimal sumInvoiceMny) {
        this.sumInvoiceMny = sumInvoiceMny;
    }
    public BigDecimal getSumInvoiceTaxMny() {
        return sumInvoiceTaxMny;
    }

    public void setSumInvoiceTaxMny(BigDecimal sumInvoiceTaxMny) {
        this.sumInvoiceTaxMny = sumInvoiceTaxMny;
    }


}
