package com.ejianc.business.equipment.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ejianc.business.equipment.bean.RentEnterArenaEntity;
import com.ejianc.business.equipment.mapper.RentWalkMapper;
import com.ejianc.business.equipment.utils.PageUtil;
import com.ejianc.business.equipment.vo.ApplyVO;
import com.ejianc.business.equipment.vo.RentEnterArenaVO;
import com.ejianc.business.equipment.vo.RentSceneVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.dozer.Mapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.equipment.bean.RentWalkEntity;
import com.ejianc.business.equipment.service.IRentWalkService;
import com.ejianc.business.equipment.vo.RentWalkVO;

/**
 * 设备退场单
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("rentWalk")
public class RentWalkController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "EQUIPMENT_RENTWALK";//此处需要根据实际修改
    
    @Autowired
    private IRentWalkService service;



    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RentWalkVO> saveOrUpdate(@RequestBody RentWalkVO saveorUpdateVO) {
    	RentWalkEntity entity = BeanMapper.map(saveorUpdateVO, RentWalkEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	entity.setOrgId(InvocationInfoProxy.getOrgId());
    	service.saveOrUpdate(entity, false);
    	RentWalkVO vo = BeanMapper.map(entity, RentWalkVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RentWalkVO> queryDetail(Long id) {
    	RentWalkEntity entity = service.selectById(id);
    	RentWalkVO vo = BeanMapper.map(entity, RentWalkVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RentWalkVO> vos) {
        service.removeByIds(vos.stream().map(RentWalkVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<RentWalkVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("createTime");
        fuzzyFields.add("billCode");
        fuzzyFields.add("arenaDate");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<RentWalkEntity> page = service.queryPage(param,false);
        IPage<RentWalkVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), RentWalkVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("createTime");
        fuzzyFields.add("billCode");
        fuzzyFields.add("arenaDate");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<RentWalkEntity> list = service.queryList(param);
        List<RentWalkVO> vos = new ArrayList<>();
        for(RentWalkEntity entity : list){
            RentWalkVO vo = BeanMapper.map(entity, RentWalkVO.class);
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            vos.add(vo);
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", vos);
        ExcelExport.getInstance().export("rentWalk-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refRentWalkData", method = RequestMethod.GET)
    @ResponseBody
    public  CommonResponse<IPage<RentSceneVO>>  refRentWalkData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                              String condition,
                                                              String searchObject,
                                                              String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        //** 租户隔离 *//*
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
        List<RentSceneVO> rentSceneVOList = new ArrayList<>();
        if(null != conditionMap.get("contractId")) {
            Long contractId = Long.valueOf(conditionMap.get("contractId").toString());
             rentSceneVOList = service.getRenScene(InvocationInfoProxy.getTenantid(),contractId,searchText);
        }
      /*  for(RentSceneVO res :rentSceneVOList){//如果退场数量为null则在场数量等于进场数量
            if(res.getSceneNum()==null){
                res.setSceneNum(res.getNumCountJin());
            }
        }*/
        List<RentSceneVO> records = PageUtil.listToPage(rentSceneVOList, pageNumber, pageSize);
        IPage<RentSceneVO> page = new Page<>();
        page.setRecords(records);
        page.setCurrent(pageNumber);
        page.setSize(pageSize);
        page.setTotal(rentSceneVOList.size());
        return CommonResponse.success("查询列表数据成功！",page);
     }
}
