package com.ejianc.business.equipment.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.equipment.bean.*;
import com.ejianc.business.equipment.service.IRentChangeService;
import com.ejianc.business.equipment.service.IRentContractService;
import com.ejianc.business.equipment.vo.SupplementRentContractRecordVO;
import com.ejianc.business.equipment.vo.SupplementRentContractVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.equipment.mapper.SupplementRentContractMapper;
import com.ejianc.business.equipment.service.ISupplementRentContractService;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 设备租赁合同补充协议
 * 
 * @author generator
 * 
 */
@Service("supplementRentContractService")
public class SupplementRentContractServiceImpl extends BaseServiceImpl<SupplementRentContractMapper, SupplementRentContractEntity> implements ISupplementRentContractService{

    private static final String EQUIPMENT_SUPPLEMENT_BILL_CODE = "EQUIPMENT_RENT_BCXY";

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IRentContractService contractService;

    @Autowired
    private IRentChangeService changeService;

    @Autowired
    private SessionManager sessionManager;


    @Override
    public SupplementRentContractVO addConvertByConId(Long contractId) {
        RentContractEntity entity = contractService.selectById(contractId);
//        SupplementRentContractVO supplementVO = BeanMapper.map(entity, SupplementRentContractVO.class);
//        //新增逻辑处理
//        //新增即点变更按钮穿透过来，此时ID为合同id
//        supplementVO.setId(null);
//        supplementVO.setBillState(null);
//        supplementVO.setCreateUserCode(null);
//        supplementVO.setCreateTime(null);
//        supplementVO.setUpdateUserCode(null);
//        supplementVO.setUpdateTime(null);
//        supplementVO.setVersion(null);
//        supplementVO.setMainContractId(supplementVO.getId());
//        supplementVO.setMainContractCode(supplementVO.getBillCode());
//        supplementVO.setMainContractName(supplementVO.getContractName());
//        supplementVO.setRentclause(null);
//        supplementVO.setRentdetail(null);
//        supplementVO.setRentfee(null);
//        supplementVO.setRentstage(null);

        SupplementRentContractVO supplementVO = new SupplementRentContractVO();
        supplementVO.setProjectId(entity.getProjectId());
        supplementVO.setProjectName(entity.getProjectName());
        supplementVO.setOrgId(entity.getOrgId());
        supplementVO.setOrgName(entity.getOrgName());
        supplementVO.setSupplierId(entity.getSupplierId());
        supplementVO.setSupplierName(entity.getSupplierName());
        supplementVO.setCustomerId(entity.getCustomerId());
        supplementVO.setCustomerName(entity.getCustomerName());
        supplementVO.setTaxRate(entity.getTaxRate());
        supplementVO.setSupplementFlag(1);
        supplementVO.setContractStatus("2");
        supplementVO.setEmployeeId(Long.valueOf(InvocationInfoProxy.getEmployeeId()));
        supplementVO.setEmployeeName(sessionManager.getUserContext().getUserName());
        supplementVO.setSignDate(new Date());
        supplementVO.setPayScale(entity.getPayScale());
        supplementVO.setMainContractId(entity.getId());
        supplementVO.setMainContractCode(entity.getBillCode());
        supplementVO.setMainContractName(entity.getContractName());
        supplementVO.setPurchaseOrgId(entity.getPurchaseOrgId());
        supplementVO.setPurchaseOrgName(entity.getPurchaseOrgName());
        supplementVO.setReplaceSignFlag(entity.getReplaceSignFlag());
        return supplementVO;
    }

    @Override
    public SupplementRentContractRecordVO queryDetailRecord(Long id) {
        RentContractEntity contractEntity = contractService.selectById(id);
        SupplementRentContractRecordVO recordVO = new SupplementRentContractRecordVO();
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        BigDecimal baseTaxMny = contractEntity.getBaseTaxMoney() == null ? BigDecimal.ZERO : contractEntity.getBaseTaxMoney();
        recordVO.setContractId(id);
        recordVO.setContractTaxMny(contractTaxMny);
        recordVO.setBaseTaxMoney(baseTaxMny);
        recordVO.setSettlementType(contractEntity.getSettlementType());
        recordVO.setChangeStatus(contractEntity.getChangeStatus());
        recordVO.setOrgId(contractEntity.getPurchaseOrgId());
        LambdaQueryWrapper<SupplementRentContractEntity> lambda = Wrappers.<SupplementRentContractEntity>lambdaQuery();
        lambda.eq(SupplementRentContractEntity::getMainContractId, id);
        lambda.orderByDesc(SupplementRentContractEntity::getSignDate);
//        lambda.in(SupplementRentContractEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<SupplementRentContractEntity> entities = super.list(lambda);
        recordVO.setSupplementRecord(BeanMapper.mapList(entities, SupplementRentContractVO.class));
        return recordVO;
    }

    @Override
    public SupplementRentContractVO insertOrUpdate(SupplementRentContractVO supplementVO) {
        if(checkFinishContract(supplementVO)){
            throw new BusinessException("该合同在相同组织下已经完工，不允许变更！");
        }

        Long tenantId = InvocationInfoProxy.getTenantid();
//        SupplementRentContractEntity entity = null;
        List<SupplementRentContractEntity> entities = null;

        //补充协议只能存在一条未生效的
        LambdaQueryWrapper<SupplementRentContractEntity> lambdaQuery = Wrappers.<SupplementRentContractEntity>lambdaQuery();
        lambdaQuery.eq(SupplementRentContractEntity::getTenantId, tenantId);
        lambdaQuery.eq(SupplementRentContractEntity::getMainContractId, supplementVO.getMainContractId());
        if(supplementVO.getId() != null && supplementVO.getId() > 0) {
            lambdaQuery.ne(SupplementRentContractEntity::getId, supplementVO.getId());
        }
        lambdaQuery.ne(SupplementRentContractEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdaQuery.ne(SupplementRentContractEntity::getBillState,BillStateEnum.COMMITED_STATE.getBillStateCode());
        int num = super.count(lambdaQuery);
        if(num > 0){
            throw new BusinessException("该合同已存在未生效的补充协议!");
        }

        //补充协议只能存在一条未生效的变更单
        LambdaQueryWrapper<RentChangeEntity> lambdachange = Wrappers.<RentChangeEntity>lambdaQuery();
        lambdachange.eq(RentChangeEntity::getTenantId, tenantId);
        lambdachange.eq(RentChangeEntity::getContractId, supplementVO.getMainContractId());
        lambdachange.ne(RentChangeEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdachange.ne(RentChangeEntity::getBillState,BillStateEnum.COMMITED_STATE.getBillStateCode());
        int changeNum = changeService.count(lambdachange);
        if(changeNum > 0){
            throw new BusinessException("该合同已存在未生效的变更单!");
        }
        if(StringUtils.isEmpty(supplementVO.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(EQUIPMENT_SUPPLEMENT_BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                supplementVO.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        if(supplementVO.getId() != null && supplementVO.getId() > 0) {
            //修改 校验合同编号唯一
            LambdaQueryWrapper<SupplementRentContractEntity> lambda = Wrappers.<SupplementRentContractEntity>lambdaQuery();
            lambda.eq(SupplementRentContractEntity::getBillCode, supplementVO.getBillCode());
            lambda.eq(SupplementRentContractEntity::getTenantId, tenantId);
            lambda.eq(SupplementRentContractEntity::getSupplementFlag, 1);//过滤非合同补充协议
            lambda.ne(SupplementRentContractEntity::getId, supplementVO.getId());
            entities = super.list(lambda);
        }else{
            LambdaQueryWrapper<SupplementRentContractEntity> lambda = Wrappers.<SupplementRentContractEntity>lambdaQuery();
            lambda.eq(SupplementRentContractEntity::getBillCode, supplementVO.getBillCode());
            lambda.eq(SupplementRentContractEntity::getSupplementFlag, 1);//过滤非合同补充协议
            lambda.eq(SupplementRentContractEntity::getTenantId, tenantId);
            entities = super.list(lambda);
        }

        if(entities != null && entities.size() > 0) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }

        SupplementRentContractEntity supplementEntity = BeanMapper.map(supplementVO, SupplementRentContractEntity.class);
        //保存前清空主键和父主键，重新生成
        List<SupplementRentContractDetailEntity> beforeDetails = supplementEntity.getRentdetail();
        if(CollectionUtils.isNotEmpty(beforeDetails) && null == supplementEntity.getId()){
            for(SupplementRentContractDetailEntity cdEntity : beforeDetails){
                cdEntity.setId(null);
            }
        }
        super.saveOrUpdate(supplementEntity, false);
        return BeanMapper.map(supplementEntity, SupplementRentContractVO.class);
    }

    private Boolean checkFinishContract(SupplementRentContractVO supplementVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper<RentContractEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(RentContractEntity::getId, supplementVO.getMainContractId());
        lambda.eq(RentContractEntity::getTenantId, tenantId);
        lambda.eq(RentContractEntity::getSettlementType, 1);
        return contractService.list(lambda).size() > 0;
    }
    
}
