/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.equipment.utils;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.pub.utils.HttpTookit;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.CustomerVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.ICustomerApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.foundation.support.api.ISupplierWebApi;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class NCUtil {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private ICustomerApi customerApi;
    @Autowired
    private ISupplierApi supplierApi;
    @Autowired
    private ISupplierWebApi supplierWebApi;
    @Autowired
    private IDefdocApi defdocApi;
    @Value(value="${nc.ncArUrl}")
    private String ncArUrl;
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    private static final Map<Integer, String> invoiceMainMap = new HashMap<Integer, String>();
    private static final Map<Integer, String> taxWayMap;

    public String getInvoiceMainDefCode(Integer key) {
        if (key == null) {
            throw new BusinessException("\u9879\u76ee-\u5f00\u7968\u4e3b\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (invoiceMainMap.containsKey(key)) {
            return invoiceMainMap.get(key);
        }
        return null;
    }

    public String getTaxWayDefCode(Integer key) {
        if (key == null) {
            throw new BusinessException("\u9879\u76ee-\u8ba1\u7a0e\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (taxWayMap.containsKey(key)) {
            return taxWayMap.get(key);
        }
        return null;
    }

    public String getTaxRateDefCode(BigDecimal taxRate) {
        String tax;
        if (taxRate == null) {
            throw new BusinessException("\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<DefdocDetailVO> defList = this.getDefDocListById(515260415240835083L);
        Map<String, String> defMap = defList.stream().collect(Collectors.toMap(x -> x.getName(), DefdocDetailVO::getCode));
        if (defMap.containsKey(tax = taxRate.stripTrailingZeros().toPlainString() + "%")) {
            return defMap.get(tax);
        }
        throw new BusinessException("\u5f55\u5165\u7a0e\u7387\u201c" + tax + "\u201d\u548c\u8d22\u52a1\u7a0e\u7387\u4e0d\u4e00\u81f4\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u5904\u7406\uff01");
    }

    public String getAssetTypesDefCode(Long id) {
        if (id == null) {
            throw new BusinessException("\u8d44\u4ea7\u7c7b\u522b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<DefdocDetailVO> defList = this.getDefDocListById(521265701567074329L);
        Map<Long, String> defMap = defList.stream().collect(Collectors.toMap(BaseVO::getId, DefdocDetailVO::getCode));
        if (defMap.containsKey(id)) {
            return defMap.get(id);
        }
        throw new BusinessException("\u5f55\u5165\u8d44\u4ea7\u7c7b\u522b\u548c\u8d22\u52a1\u8d44\u4ea7\u7c7b\u522b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u5904\u7406\uff01");
    }

    public List<DefdocDetailVO> getDefDocListById(Long id) {
        CommonResponse resp = this.defdocApi.getDefDocByDefId(id);
        if (!resp.isSuccess()) {
            throw new BusinessException(resp.getMsg());
        }
        return (List)resp.getData();
    }

    public DefdocDetailVO getDefDocById(Long id) {
        CommonResponse resp = this.defdocApi.getDefDocById(id);
        if (!resp.isSuccess()) {
            throw new BusinessException(resp.getMsg());
        }
        return (DefdocDetailVO)resp.getData();
    }

    public OrgVO queryOrgById(Long id) {
        CommonResponse resp = this.orgApi.detailById(id);
        if (!resp.isSuccess()) {
            throw new BusinessException(resp.getMsg());
        }
        return (OrgVO)resp.getData();
    }

    public List<ProjectRegisterVO> queryProjectByIds(List<Long> ids) {
        CommonResponse resp = this.projectApi.queryProjectByIds(ids);
        if (!resp.isSuccess()) {
            throw new BusinessException(resp.getMsg());
        }
        return (List)resp.getData();
    }

    public SupplierVO querySupplierById(Long id) {
        CommonResponse resp = this.supplierApi.queryById(id);
        if (!resp.isSuccess()) {
            throw new BusinessException(resp.getMsg());
        }
        return (SupplierVO)resp.getData();
    }

    public CustomerVO queryCustomerById(Long id) {
        CommonResponse resp = this.customerApi.detailById(id);
        if (!resp.isSuccess()) {
            throw new BusinessException(resp.getMsg());
        }
        return (CustomerVO)resp.getData();
    }

    public BankAccountVO queryDefaultBankAccountById(Long id, String type) {
        CommonResponse resp = this.supplierWebApi.queryDefaultBankAccountById(id, type);
        if (!resp.isSuccess()) {
            throw new BusinessException(resp.getMsg());
        }
        return (BankAccountVO)resp.getData();
    }

    public List<Long> validateDaoQiaoOrg(Long orgId, Integer invoiceMain) {
        Long daoQiaoId = 1406795679766782028L;
        OrgVO orgVO = this.queryOrgById(orgId);
        if (orgVO.getInnerCode().contains(String.valueOf(daoQiaoId))) {
            if (new Integer(0).equals(invoiceMain) || daoQiaoId.equals(orgId)) {
                return Arrays.asList(daoQiaoId);
            }
            if (new Integer(1).equals(invoiceMain)) {
                return Arrays.asList(orgId, daoQiaoId);
            }
        }
        return Arrays.asList(orgId);
    }

    public List<Long> validateInvoiceMainOrg(Long orgId, Long mainOrgId) {
        if (!orgId.equals(mainOrgId)) {
            return Arrays.asList(orgId, mainOrgId);
        }
        return Arrays.asList(orgId);
    }

    public String postByJson(String param) {
        HashMap headers = new HashMap();
        this.logger.info("-\u4f20NC\u51ed\u8bc1\u5165\u53c2:" + param);
        String back = null;
        try {
            back = HttpTookit.postByJson((String)this.ncArUrl, (String)param, headers);
        }
        catch (Exception e) {
            try {
                back = HttpTookit.postByJson((String)this.ncArUrl, (String)param, headers);
            }
            catch (Exception e1) {
                throw new BusinessException("\u63a8\u9001NC\u63a5\u53e3\u5f02\u5e38!");
            }
        }
        this.logger.info("-\u4f20NC\u51ed\u8bc1\u56de\u53c2:" + back);
        if (!back.contains("code")) {
            throw new BusinessException("\u8fd4\u56de\u503c\u89e3\u6790\u5f02\u5e38!");
        }
        JSONObject json = JSONObject.parseObject((String)back);
        if (!"200".equals(json.getString("code"))) {
            throw new BusinessException(json.getString("msg"));
        }
        return json.getString("result");
    }

    public String getWebSite(String url) {
        Long userid = InvocationInfoProxy.getUserid();
        String targeturl = this.BASE_HOST + url;
        this.logger.info("--->> targeturl: " + targeturl);
        try {
            targeturl = URLEncoder.encode(targeturl, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String webSite = this.BASE_HOST + "portal/sso/index?userid=" + userid + "&targeturl=" + targeturl;
        this.logger.info("--->> \u751f\u6210\u5916\u90e8\u8df3\u8f6c\u5730\u5740: " + webSite);
        return webSite;
    }

    public static void voucherParam(QueryParam param) {
        if (param.getParams().containsKey("voucherState")) {
            String voucherState = String.valueOf(((Parameter)param.getParams().get("voucherState")).getValue());
            if (voucherState.contains("1")) {
                param.getParams().put("source_id", new Parameter("ne", null));
            } else {
                param.getParams().put("source_id", new Parameter("eq", null));
            }
            param.getParams().remove("voucherState");
        }
    }

    static {
        invoiceMainMap.put(0, "PMDA06001");
        invoiceMainMap.put(1, "PMDA06002");
        taxWayMap = new HashMap<Integer, String>();
        taxWayMap.put(0, "01");
        taxWayMap.put(1, "02");
        taxWayMap.put(2, "03");
    }
}

