/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.equipment.service.impl;

import com.ejianc.business.equipment.bean.RentContractEntity;
import com.ejianc.business.equipment.service.IRentContractService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="rentContract")
public class RentContractBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IRentContractService contractService;

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        RentContractEntity entity = (RentContractEntity)((Object)this.contractService.selectById(billId));
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (res.isSuccess()) {
            CommonResponse contractOrg = this.orgApi.getOneById(entity.getPurchaseOrgId());
            if (!contractOrg.isSuccess()) {
                this.logger.error("\u5f03\u5ba1\u5931\u8d25\uff0c\u83b7\u53d6\u5408\u540c\u3010{}\u3011\u6240\u5c5e\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25: \u3010{}\u3011", (Object)billId, (Object)contractOrg.getMsg());
                return CommonResponse.error((String)"\u5f03\u5ba1\u5931\u8d25\uff0c\u83b7\u53d6\u5408\u540c\u6240\u5c5e\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            CommonResponse curOrg = this.orgApi.getOneById(InvocationInfoProxy.getOrgId());
            if (!curOrg.isSuccess()) {
                this.logger.error("\u5f03\u5ba1\u5931\u8d25\uff0c\u83b7\u53d6\u83b7\u53d6\u5f53\u524d\u7528\u6237\u3010{}\u3011\u6240\u5c5e\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25: \u3010{}\u3011", (Object)InvocationInfoProxy.getOrgId(), (Object)curOrg.getMsg());
                return CommonResponse.error((String)"\u5f03\u5ba1\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7528\u6237\u767b\u5f55\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            if (!((OrgVO)contractOrg.getData()).getInnerCode().contains(((OrgVO)curOrg.getData()).getInnerCode())) {
                return CommonResponse.error((String)("\u5f53\u524d\u5408\u540c\u7f16\u5236\u7ec4\u7ec7\u662f\u3010" + entity.getPurchaseOrgName() + "\u3011, \u4e0d\u53ef\u5f03\u5ba1\uff01"));
            }
            return CommonResponse.success();
        }
        return CommonResponse.error((String)res.getMsg());
    }
}

