/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.equipment.zhgcloud.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.equipment.bean.TaibanDetailEntity;
import com.ejianc.business.equipment.bean.TaibanEntity;
import com.ejianc.business.equipment.service.ITaibanService;
import com.ejianc.business.equipment.zhgcloud.bean.ZhpResult;
import com.ejianc.business.equipment.zhgcloud.bean.taibanBean.TaibanDetail;
import com.ejianc.business.equipment.zhgcloud.bean.taibanBean.TaibanRoot;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/equipment/"})
public class EquipmentTaibanApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ITaibanService service;

    @PostMapping(value={"getTaiban"})
    public ZhpResult getTaiban(@RequestBody JSONObject json) {
        ZhpResult result = new ZhpResult();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        TaibanEntity taibanEntity = new TaibanEntity();
        TaibanDetailEntity taibanDetailEntity = new TaibanDetailEntity();
        ArrayList<TaibanDetailEntity> taibanDetailEntityList = new ArrayList<TaibanDetailEntity>();
        this.logger.info(json.toString());
        TaibanRoot taiban = (TaibanRoot)JSON.parseObject((String)json.toString(), TaibanRoot.class);
        if (taiban != null) {
            taibanEntity.setTenantKey(taiban.getTenant_key());
            taibanEntity.setMachineShiftKey(taiban.getMachine_shift_key());
            taibanEntity.setMachineShiftNumber(taiban.getMachine_shift_number());
            taibanEntity.setContractKey(taiban.getContract_key());
            taibanEntity.setBillCode(taiban.getMachine_shift_number());
            taibanEntity.setContractName("\u673a\u68b0\u8bbe\u5907\u79df\u8d41\u5408\u540c");
            taibanEntity.setSupplierName("\u674e\u6ca7\u533a\u6e20\u6210\u6e90\u673a\u68b0\u8bbe\u5907\u79df\u8d41\u90e8");
            taibanEntity.setContractDetailKey(taiban.getContract_detail_key());
            taibanEntity.setContractDetailCode(taiban.getContract_detail_code());
            taibanEntity.setMachineGuid(taiban.getMachine_info().getMachine_guid());
            taibanEntity.setMachineName(taiban.getMachine_info().getMachine_name());
            taibanEntity.setProjectKey(taiban.getProject_info().getProject_key());
            taibanEntity.setProjectName(taiban.getProject_info().getProject_name());
            taibanEntity.setStatus(taiban.getStatus());
            taibanEntity.setSendJson(json.toString());
            taibanEntity.setActualWorkTime(BigDecimal.valueOf(taiban.getActual_work_time().intValue()).divide(new BigDecimal(360)));
            try {
                taibanEntity.setCreatedAt(simpleDateFormat.parse(taiban.getCreated_at()));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            BigDecimal shifNumber = new BigDecimal(0);
            for (TaibanDetail taibanDetail : taiban.getDetail()) {
                taibanDetailEntity.setShiftDetailKey(taibanDetail.getShift_detail_key());
                taibanDetailEntity.setWorkState(taibanDetail.getWork_state());
                taibanDetailEntity.setBeginAt(taibanDetail.getBegin_at());
                taibanDetailEntity.setEndAt(taibanDetail.getEnd_at());
                taibanDetailEntity.setWorkTime(BigDecimal.valueOf(taibanDetail.getWork_time().intValue()).divide(new BigDecimal(360)));
                taibanDetailEntity.setTerminalTotalTime(BigDecimal.valueOf(taibanDetail.getTerminal_total_time().intValue()));
                taibanDetailEntity.setTerminalWorkTime(BigDecimal.valueOf(taibanDetail.getTerminal_work_time().intValue()));
                taibanDetailEntity.setTerminalIdleTime(BigDecimal.valueOf(taibanDetail.getTerminal_idle_time().intValue()));
                taibanDetailEntity.setActualWorkTime(BigDecimal.valueOf(taibanDetail.getActual_work_time().intValue()));
                taibanDetailEntity.setShiftNumber(BigDecimal.valueOf(taibanDetail.getShift_number()));
                shifNumber = shifNumber.add(BigDecimal.valueOf(taibanDetail.getShift_number()));
                taibanDetailEntity.setAccountingObject(taibanDetail.getAccounting_object_code());
                taibanDetailEntityList.add(taibanDetailEntity);
            }
            taibanEntity.setShiftNumber(shifNumber);
            taibanEntity.setTaibanDetail(taibanDetailEntityList);
        }
        this.service.saveOrUpdate((Object)taibanEntity, false);
        result.setStatus(0);
        result.setMessage("\u63a8\u9001\u6210\u529f");
        return result;
    }
}

