/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.equipment.controller;

import com.ejianc.business.equipment.mapper.PurchaseChangeMapper;
import com.ejianc.business.equipment.mapper.PurchaseContractMapper;
import com.ejianc.business.equipment.service.IPurchaseChangeService;
import com.ejianc.business.equipment.vo.PurchaseChangeRecordVO;
import com.ejianc.business.equipment.vo.PurchaseChangeVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"purchaseChange"})
public class PurchaseChangeController {
    @Autowired
    private IPurchaseChangeService purchaseChangeService;
    @Autowired
    private PurchaseChangeMapper purchaseChangeMapper;
    @Autowired
    private PurchaseContractMapper purchaseContractMapper;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PurchaseChangeVO> saveOrUpdate(@RequestBody PurchaseChangeVO purchaseChangeVo) {
        Integer count = this.purchaseChangeMapper.countClosing(purchaseChangeVo.getProjectId());
        if (count != 0) {
            Long contractId = purchaseChangeVo.getContractId();
            BigDecimal sourcemoney = this.purchaseChangeMapper.querysouremoney(contractId);
            BigDecimal contractmny = purchaseChangeVo.getContractMny();
            if (contractmny.compareTo(sourcemoney) == 1) {
                throw new BusinessException("\u672c\u9879\u76ee\u5df2\u5236\u4f5c\u6210\u672c\u5173\u95e8\u9884\u4f30\u5355\uff0c\u7981\u6b62\u589e\u5927\u5408\u540c\u989d\uff01");
            }
        }
        return this.purchaseChangeService.saveOrUpdate(purchaseChangeVo);
    }

    @RequestMapping(value={"/checkmakedata"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> checkmakedata(@RequestParam(value="projectId") Long projectId) {
        Integer count = this.purchaseContractMapper.countClosing(projectId);
        if (count != 0) {
            throw new BusinessException("\u672c\u9879\u76ee\u4e0b\u5b58\u5728\u5c1a\u672a\u8fc7\u5ba1\u7684\u6210\u672c\u5173\u95e8\u9884\u4f30\u5355\uff0c\u8bf7\u5148\u8fc7\u5ba1\uff01");
        }
        Date endtime = this.purchaseContractMapper.getCostClosingTime(projectId);
        Date now = new Date();
        if (endtime != null && now.compareTo(endtime) == 1) {
            throw new BusinessException("\u5f53\u524d\u9879\u76ee\u5df2\u4e0d\u5728\u6210\u672c\u5173\u95e8\u671f\u9650\u5185\uff0c\u65e0\u6cd5\u65b0\u589e\u5408\u540c\u53d8\u66f4\uff01");
        }
        String message = "\u6821\u9a8c\u6210\u529f\uff0c\u5141\u8bb8\u5f55\u5165\uff01";
        return CommonResponse.success((String)message);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PurchaseChangeVO> queryDetail(@RequestParam Long id) {
        PurchaseChangeVO purchaseChangeVo = this.purchaseChangeService.queryDetail(id);
        return CommonResponse.success((Object)purchaseChangeVo);
    }

    @RequestMapping(value={"/queryDetails"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PurchaseChangeVO> queryDetails(@RequestParam Long id) {
        PurchaseChangeVO purchaseChangeVo = this.purchaseChangeService.queryDetails(id);
        return CommonResponse.success((Object)purchaseChangeVo);
    }

    @RequestMapping(value={"/queryDetailRecord"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PurchaseChangeRecordVO> queryDetailRecord(@RequestParam Long id) {
        PurchaseChangeRecordVO changeRecordVO = this.purchaseChangeService.queryChangeRecord(id);
        return CommonResponse.success((Object)changeRecordVO);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PurchaseChangeVO> vos) {
        this.purchaseChangeService.deletePurchaseChange(vos);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }
}

