/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.equipment.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.equipment.service.IRentUseRecordDetailService;
import com.ejianc.business.equipment.service.IRentUseRecordFeeService;
import com.ejianc.business.equipment.service.IRentUseRecordService;
import com.ejianc.business.equipment.vo.RentUseRecordLeftVO;
import com.ejianc.business.equipment.vo.RentUseRecordVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"rentUseRecord"})
public class RentUseRecordController {
    @Autowired
    private IRentUseRecordService rentUseRecordService;
    @Autowired
    private IRentUseRecordDetailService rentUseRecordDetailService;
    @Autowired
    private IRentUseRecordFeeService rentUseRecordFeeService;
    @Autowired
    private IOrgApi orgApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<RentUseRecordVO> saveOrUpdate(@RequestBody RentUseRecordVO rentUseRecordVo) {
        return this.rentUseRecordService.saveOrUpdate(rentUseRecordVo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<RentUseRecordVO> queryDetail(@RequestParam Long id) {
        RentUseRecordVO rentUseRecordVo = this.rentUseRecordService.queryDetail(id);
        return CommonResponse.success((Object)rentUseRecordVo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RentUseRecordVO> vos) {
        this.rentUseRecordService.deleteRentUseRecord(vos);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("equipmentName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage pageData = this.rentUseRecordService.queryPage(param, false);
        JSONObject page = new JSONObject();
        page.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), RentUseRecordVO.class));
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/pageListRef"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> pageListRef(@RequestBody RentUseRecordLeftVO rentUseRecordLeftVO) {
        QueryParam param = new QueryParam();
        param.setPageSize(rentUseRecordLeftVO.getPageSize());
        param.setPageIndex(rentUseRecordLeftVO.getPageIndex());
        param.setSearchText(rentUseRecordLeftVO.getBillCode());
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("contractName");
        param.getOrderMap().put("create_time", "desc");
        if (null != rentUseRecordLeftVO.getContractId()) {
            param.getParams().put("contractId", new Parameter("eq", (Object)rentUseRecordLeftVO.getContractId()));
        }
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("use_flag", new Parameter("eq", (Object)0));
        param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage pageData = this.rentUseRecordService.queryPage(param, false);
        JSONObject page = new JSONObject();
        page.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), RentUseRecordVO.class));
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @GetMapping(value={"/rentUseRecordRef"})
    public CommonResponse<IPage<RentUseRecordVO>> rentUseRecordRef(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        Map conditionMap;
        JSONObject jsonObject = new JSONObject();
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("billCode");
        queryParam.getFuzzyFields().add("contractName");
        queryParam.getFuzzyFields().add("projectName");
        queryParam.getFuzzyFields().add("equipmentName");
        queryParam.getFuzzyFields().add("supplierName");
        ArrayList<Integer> billstate = new ArrayList<Integer>();
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        queryParam.getParams().put("bill_state", new Parameter("in", billstate));
        if (StringUtils.isNotBlank((CharSequence)condition) && null != (conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class)).get("contractId")) {
            queryParam.getParams().put("contract_id", new Parameter("eq", conditionMap.get("contractId")));
            queryParam.getParams().put("use_flag", new Parameter("eq", (Object)0));
        }
        IPage pageData = this.rentUseRecordService.queryPage(queryParam, false);
        pageData.getRecords().forEach(e -> {
            Long id = e.getId();
            QueryParam queryParamDetail = new QueryParam();
            queryParamDetail.getParams().put("use_id", new Parameter("eq", (Object)id));
            queryParamDetail.getParams().put("dr", new Parameter("eq", (Object)0));
            QueryParam queryParamFee = new QueryParam();
            queryParamFee.getParams().put("use_id", new Parameter("eq", (Object)id));
            queryParamFee.getParams().put("dr", new Parameter("eq", (Object)0));
            List rentUseRecordDetail = this.rentUseRecordDetailService.queryList(queryParamDetail);
            List rentUseRecordFree = this.rentUseRecordFeeService.queryList(queryParamFee);
            e.setRentdetail(rentUseRecordDetail);
            e.setRentfee(rentUseRecordFree);
        });
        Page result = new Page(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        result.setRecords(BeanMapper.mapList((Iterable)pageData.getRecords(), RentUseRecordVO.class));
        return CommonResponse.success((String)"\u53c2\u7167\u67e5\u8be2\u6210\u529f\uff01", (Object)result);
    }

    @RequestMapping(value={"/queryDetails"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<RentUseRecordVO> queryDetails(@RequestParam Long id) {
        RentUseRecordVO rentSettlementVO = this.rentUseRecordService.queryDetails(id);
        return CommonResponse.success((Object)rentSettlementVO);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("equipmentName");
        fuzzyFields.add("billCode");
        param.setPageIndex(1);
        param.setPageSize(10000);
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        ArrayList commonOrgIds = new ArrayList();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            throw new BusinessException("\u5408\u540c\u5206\u9875\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        }
        IPage pageData = this.rentUseRecordService.queryPage(param, false);
        List list = new ArrayList();
        if (null != pageData.getRecords() && CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            list = BeanMapper.mapList((Iterable)pageData.getRecords(), RentUseRecordVO.class);
            list.forEach(vo -> vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription()));
        }
        HashMap beans = new HashMap();
        beans.put("records", list);
        ExcelExport.getInstance().export("rentUseListExport.xlsx", beans, response);
    }
}

