/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.equipment.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.equipment.bean.SupplementRentContractEntity;
import com.ejianc.business.equipment.mapper.RentContractMapper;
import com.ejianc.business.equipment.service.IRentContractService;
import com.ejianc.business.equipment.service.ISupplementRentContractService;
import com.ejianc.business.equipment.vo.SupplementRentContractRecordVO;
import com.ejianc.business.equipment.vo.SupplementRentContractVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"supplementRentContract"})
public class SupplementRentContractController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISupplementRentContractService service;
    @Autowired
    private IRentContractService rentContractService;
    @Autowired
    private RentContractMapper rentContractMapper;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SupplementRentContractVO> saveOrUpdate(@RequestBody SupplementRentContractVO saveorUpdateVO) {
        SupplementRentContractVO vo = this.service.insertOrUpdate(saveorUpdateVO);
        this.rentContractService.updateContractIsSupplementFlag(saveorUpdateVO.getMainContractId());
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/checkmakedata"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> checkmakedata(@RequestParam(value="projectId") Long projectId) {
        Integer count = this.rentContractMapper.countClosing(projectId);
        if (count != 0) {
            throw new BusinessException("\u672c\u9879\u76ee\u4e0b\u5b58\u5728\u5c1a\u672a\u8fc7\u5ba1\u7684\u6210\u672c\u5173\u95e8\u9884\u4f30\u5355\uff0c\u8bf7\u5148\u8fc7\u5ba1\uff01");
        }
        Date endtime = this.rentContractMapper.getCostClosingTime(projectId);
        Date now = new Date();
        if (endtime != null && now.compareTo(endtime) == 1) {
            throw new BusinessException("\u5f53\u524d\u9879\u76ee\u5df2\u4e0d\u5728\u6210\u672c\u5173\u95e8\u671f\u9650\u5185\uff0c\u65e0\u6cd5\u65b0\u589e\u8865\u5145\u534f\u8bae\uff01");
        }
        String message = "\u6821\u9a8c\u6210\u529f\uff0c\u5141\u8bb8\u5f55\u5165\uff01";
        return CommonResponse.success((String)message);
    }

    @RequestMapping(value={"/addConvertByConId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SupplementRentContractVO> addConvertByConId(Long contractId) {
        SupplementRentContractVO vo = this.service.addConvertByConId(contractId);
        return CommonResponse.success((String)"\u65b0\u589e\u8f6c\u6362\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetailRecord"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SupplementRentContractRecordVO> queryDetailRecord(Long id) {
        SupplementRentContractRecordVO vo = this.service.queryDetailRecord(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SupplementRentContractVO> queryDetail(Long id) {
        SupplementRentContractEntity entity = (SupplementRentContractEntity)((Object)this.service.selectById(id));
        SupplementRentContractVO vo = (SupplementRentContractVO)BeanMapper.map((Object)((Object)entity), SupplementRentContractVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SupplementRentContractVO> vos) {
        int i;
        Long[] ids = new Long[vos.size()];
        for (i = 0; i < ids.length; ++i) {
            SupplementRentContractEntity entity = (SupplementRentContractEntity)((Object)this.service.getById(vos.get(i).getId()));
            ids[i] = entity.getMainContractId();
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        for (i = 0; i < ids.length; ++i) {
            this.rentContractService.updateContractIsSupplementFlag(ids[i]);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SupplementRentContractVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SupplementRentContractVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

