package com.ejianc.business.equipment.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @Author sunyj
 * @Date 2020/5/27 设备采购合同
 * @Description RentContractEntity
 */

@TableName("ejc_equipment_rent_contract")
public class RentContractEntity extends BaseEntity {

    private static final long serialVersionUID = 2779265683222439571L;

    /**
     * 合同编码
     */
    @TableField(value = "bill_code")
    private String billCode;

    /**
     * 合同名称
     */
    @TableField(value = "contract_name")
    private String contractName;


    /**
     * 合同状态：1-履约, 2-中止，3-终止，4-废除，5-封账
     */
    @TableField(value = "contract_status")
    private Integer contractStatus;

    /**
     * 项目
     */
    @TableField(value = "project_id")
    private Long projectId;

    /**
     * 组织
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 经办人
     */
    @TableField(value = "employee_id")
    private Long employeeId;

    /**
     * 总包企业名称
     */
    @TableField(value = "customer_id")
    private Long customerId;

    /**
     * 设备供应商
     */
    @TableField(value = "supplier_id")
    private Long supplierId;

    /**
     * 签约日期
     */
    @TableField(value = "sign_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate;

    /**
     * 合同金额(不含税)
     */
    @TableField(value = "contract_mny")
    private BigDecimal contractMny;

    /**
     * 税金
     */
    @TableField(value = "tax_mny")
    private BigDecimal taxMny;

    /**
     * 合同金额
     */
    @TableField(value = "contract_tax_mny")
    private BigDecimal contractTaxMny;

    /**
     * 合同税率
     */
    @TableField(value = "tax_rate")
    private BigDecimal taxRate;

    /**
     * 合同支付比例
     */
    @TableField(value = "pay_scale")
    private BigDecimal payScale;


    /**
     * 备注
     */
    @TableField(value = "memo")
    private String memo;

    /**
     * 单据状态（审批必须字段）
     */
    @TableField(value = "bill_state")
    private Integer billState;
    // 设备明细子表
    @TableField(exist = false)
    @SubEntity(serviceName="RentDetailsServiceImpl",pidName = "contractId")
    private List<RentDetailsEntity> rentdetails = new ArrayList<>();

    // 合同条款子表
    @TableField(exist = false)
    @SubEntity(serviceName="RentClauseServiceImpl",pidName = "contractId")
    private List<RentClauseEntity> rentclause = new ArrayList<>();

    // 其他费用子表
    @TableField(exist = false)
    @SubEntity(serviceName="RentCostServiceImpl",pidName = "contractId")
    private List<RentCostEntity> rentcost = new ArrayList<>();

    public List<RentDetailsEntity> getRentdetails() {
        return rentdetails;
    }

    public void setRentdetails(List<RentDetailsEntity> rentdetails) {
        this.rentdetails = rentdetails;
    }

    public List<RentClauseEntity> getRentclause() {
        return rentclause;
    }

    public void setRentclause(List<RentClauseEntity> rentclause) {
        this.rentclause = rentclause;
    }

    public List<RentCostEntity> getRentcost() {
        return rentcost;
    }

    public void setRentcost(List<RentCostEntity> rentcost) {
        this.rentcost = rentcost;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public Integer getContractStatus() {
        return contractStatus;
    }

    public void setContractStatus(Integer contractStatus) {
        this.contractStatus = contractStatus;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getPayScale() {
        return payScale;
    }

    public void setPayScale(BigDecimal payScale) {
        this.payScale = payScale;
    }


    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
}
