package com.ejianc.business.equipment.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.equipment.bean.PurchaseContractEntity;
import com.ejianc.business.equipment.service.IPurchaseContractService;
import com.ejianc.business.equipment.vo.PurchaseContractVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.web.bind.annotation.*;
import com.alibaba.fastjson.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("purchaseContract")
public class PurchaseContractController {

    @Autowired
    private IPurchaseContractService purchaseContractService;

    @Autowired
    private IOrgApi orgApi;

    /**
     * 新增或者修改
     *
     * @param purchaseContractVo
     * @return
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PurchaseContractVO> saveOrUpdate(@RequestBody PurchaseContractVO purchaseContractVo) {
        return purchaseContractService.saveOrUpdate(purchaseContractVo);
    }

    /**
     * 根据主键ID查询供方详情
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PurchaseContractVO> queryDetail(@RequestParam Long id) {
        PurchaseContractVO purchaseContractVo = purchaseContractService.queryDetail(id);
        return CommonResponse.success(purchaseContractVo);
    }

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        purchaseContractService.deletePurchaseContract(ids);
        return CommonResponse.success("删除成功");
    }

    /**
     * 查询供方分页列表
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/pageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id",new Parameter("eq",InvocationInfoProxy.getTenantid()));
        IPage<PurchaseContractEntity> pageData= purchaseContractService.queryPage(param,false);
        com.alibaba.fastjson.JSONObject page = new com.alibaba.fastjson.JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), PurchaseContractVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        return CommonResponse.success("查询列表数据成功！",page);
    }

    /**
     * 查询指定组织本下的所有项目信息列表
     *
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchText
     * @return
     */
    @GetMapping("/purchaseContractRef")
    public com.alibaba.fastjson.JSONObject projectListRefe(@RequestParam(defaultValue = "1") Integer pageNumber,
                                                           @RequestParam(defaultValue = "10") Integer pageSize,
                                                           @RequestParam(value = "condition", required = true) String condition,
                                                           @RequestParam(value = "searchText", required = false) String searchText) {

        com.alibaba.fastjson.JSONObject jsonObject = new com.alibaba.fastjson.JSONObject();
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("contractName");
        queryParam.getFuzzyFields().add("billCode");

        List<Long> commonOrgIds = new ArrayList<>();
        List<Long> departmentIds = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();

        if(StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = new HashMap<>();

            if(null != conditionMap.get("orgId")) {
                orgId = Long.valueOf(conditionMap.get("orgId").toString());
            }
        }

        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if(!orgListResp.isSuccess()) {
            Page<PurchaseContractVO> page = new PageImpl<>(new ArrayList<>(),new PageRequest(pageNumber,pageSize), 0);
            jsonObject.put("data", page);
            jsonObject.put("code", "failure");
            jsonObject.put("msg", "查询数表参照失败，项目组织信息查询失败！");
            return jsonObject;
        }
        List<OrgVO> orgList = orgListResp.getData();

        orgList.stream().forEach(orgVO -> {
            if(5 == orgVO.getOrgType()) {
                //项目部
                departmentIds.add(orgVO.getId());
            } else {
                //普通组织
                commonOrgIds.add(orgVO.getId());
            }
            if(CollectionUtils.isNotEmpty(departmentIds)) {
                queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
            } else if(CollectionUtils.isNotEmpty(departmentIds)) {
                queryParam.getParams().put("projectDepartmentId", new Parameter(QueryParam.EQ, departmentIds.get(0)));
            }
        });

        IPage<PurchaseContractEntity> pageData = purchaseContractService.queryPage(queryParam,false);
        Page<PurchaseContractVO> page = new PageImpl<>( BeanMapper.mapList(pageData.getRecords(), PurchaseContractVO.class),
                new PageRequest(pageNumber,pageSize), pageData.getTotal());
        jsonObject.put("data", page);
        jsonObject.put("code", "success");
        jsonObject.put("msg", "查询数表参照成功！");
        return jsonObject;
    }
}
