package com.ejianc.business.equipment.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.equipment.bean.RentContractEntity;
import com.ejianc.business.equipment.service.IRentContractService;
import com.ejianc.business.equipment.vo.PurchaseContractVO;
import com.ejianc.business.equipment.vo.RentContractVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("rentContract")
public class RentContractController {

    @Autowired
    private IRentContractService rentContractService;

    /**
     * 新增或者修改
     *
     * @param rentContractVo
     * @return
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RentContractVO> saveOrUpdate(@RequestBody RentContractVO rentContractVo) {
        CommonResponse<RentContractVO> response = rentContractService.saveOrUpdate(rentContractVo);
        return response;
    }

    /**
     * 根据主键ID查询供方详情
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RentContractVO> queryDetail(@RequestParam Long id) {
        RentContractVO rentContractVo = rentContractService.queryDetail(id);
        return CommonResponse.success(rentContractVo);
    }

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        rentContractService.deleteRentContract(ids);
        return CommonResponse.success("删除成功");
    }

    /**
     * 查询供方分页列表
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/pageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<RentContractEntity>> pageList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("contractCode");
        return CommonResponse.success("查询列表数据成功！",rentContractService.queryPage(param,false));
    }
}
