package com.ejianc.business.equipment.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.equipment.bean.PurchaseContractEntity;
import com.ejianc.business.equipment.mapper.PurchaseContractMapper;
import com.ejianc.business.equipment.service.IPurchaseContractClauseService;
import com.ejianc.business.equipment.service.IPurchaseContractService;
import com.ejianc.business.equipment.service.IPurchaseContractFeeService;
import com.ejianc.business.equipment.service.IPurchaseContractDetailService;
import com.ejianc.business.equipment.vo.PurchaseContractVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;

@Service
public class PurchaseContractServiceImpl extends BaseServiceImpl<PurchaseContractMapper, PurchaseContractEntity> implements IPurchaseContractService {

    private static final String PURCHASE_CONTRACT_BILL_CODE = "EQUIPMENT_PURCHASE";

    @Autowired
    private PurchaseContractMapper purchaseContractMapper;

    @Autowired
    private IPurchaseContractDetailService purchaseDetailsService;

    @Autowired
    private IPurchaseContractFeeService purchaseCostService;

    @Autowired
    private IPurchaseContractClauseService purchaseClauseService;

//    @Autowired
//    private IDefdocDetailService defdocDetailService;

    @Autowired
    private IBillCodeApi billCodeApi;
    @Override
    public CommonResponse<PurchaseContractVO> saveOrUpdate(PurchaseContractVO purchaseContractVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        PurchaseContractEntity entity = null;
        String operateType = null;
        if(StringUtils.isEmpty(purchaseContractVo.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(PURCHASE_CONTRACT_BILL_CODE,tenantId);
            if(billCode.isSuccess()) {
                purchaseContractVo.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if(purchaseContractVo.getId() != null && purchaseContractVo.getId() > 0) {
            //修改  校验合同编号是否重复
            LambdaQueryWrapper<PurchaseContractEntity> lambda = Wrappers.<PurchaseContractEntity>lambdaQuery();
            lambda.eq(PurchaseContractEntity::getBillCode, purchaseContractVo.getBillCode());
            lambda.eq(PurchaseContractEntity::getTenantId, tenantId);
            lambda.ne(PurchaseContractEntity::getId, purchaseContractVo.getId());
            List<PurchaseContractEntity> entities = super.list(lambda);
            if(entities != null && entities.size() > 0) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
        }else{
            //校验合同编号是否重复
            LambdaQueryWrapper<PurchaseContractEntity> lambda = Wrappers.<PurchaseContractEntity>lambdaQuery();
            lambda.eq(PurchaseContractEntity::getTenantId, tenantId);
            lambda.eq(PurchaseContractEntity::getBillCode, purchaseContractVo.getBillCode());
            List<PurchaseContractEntity> entities = super.list(lambda);
            if(entities != null && entities.size() > 0) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
        }
        entity = BeanMapper.map(purchaseContractVo, PurchaseContractEntity.class);
        entity.setBaseMoney(purchaseContractVo.getContractTaxMny()==null?BigDecimal.ZERO:purchaseContractVo.getContractTaxMny());
        entity.setBeforeChangeMny(purchaseContractVo.getContractTaxMny()==null?BigDecimal.ZERO:purchaseContractVo.getContractTaxMny());
        super.saveOrUpdate(entity,false);

        return CommonResponse.success(BeanMapper.map(entity, PurchaseContractVO.class));
    }

    @Override
    public PurchaseContractVO queryDetail(Long id) {
        PurchaseContractEntity entity = super.selectById(id);
        PurchaseContractVO purchaseContractVo = BeanMapper.map(entity, PurchaseContractVO.class);
        return purchaseContractVo;
    }

    @Override
    public void deletePurchaseContract(List<Long> ids) {
        super.removeByIds(ids,false);
    }
}