package com.ejianc.business.equipment.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.equipment.bean.*;
import com.ejianc.business.equipment.mapper.RentContractMapper;
import com.ejianc.business.equipment.service.IRentClauseService;
import com.ejianc.business.equipment.service.IRentContractService;
import com.ejianc.business.equipment.service.IRentCostService;
import com.ejianc.business.equipment.service.IRentDetailsService;
import com.ejianc.business.equipment.vo.*;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service("RentContractService")
public class RentContractServiceImpl extends BaseServiceImpl<RentContractMapper, RentContractEntity> implements IRentContractService {

    private static final String RENT_CONTRACT_BILL_CODE = "EQUIPMENT_RENT";

    @Autowired
    private RentContractMapper rentContractMapper;

    @Autowired
    private IRentDetailsService rentDetailsService;

    @Autowired
    private IRentCostService rentCostService;

    @Autowired
    private IRentClauseService rentClauseService;

//    @Autowired
//    private IDefdocDetailService defdocDetailService;

    @Autowired
    private IBillCodeApi billCodeApi;
    @Override
    public CommonResponse<RentContractVO> saveOrUpdate(RentContractVO rentContractVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        RentContractEntity entity = null;
        String operateType = null;
        if(StringUtils.isEmpty(rentContractVo.getBillCode())){
            //新增
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(RENT_CONTRACT_BILL_CODE,tenantId);
            if(billCode.isSuccess()) {
                rentContractVo.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if(rentContractVo.getId() != null && rentContractVo.getId() > 0) {
            //修改  校验合同编号是否重复
            LambdaQueryWrapper<RentContractEntity> lambda = Wrappers.<RentContractEntity>lambdaQuery();
            lambda.eq(RentContractEntity::getBillCode, rentContractVo.getBillCode());
            lambda.eq(RentContractEntity::getTenantId, tenantId);
            lambda.ne(RentContractEntity::getId, rentContractVo.getId());
            List<RentContractEntity> entities = super.list(lambda);
            if(entities != null && entities.size() > 0) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
        }else{
            //校验合同编号是否重复
            LambdaQueryWrapper<RentContractEntity> lambda = Wrappers.<RentContractEntity>lambdaQuery();
            lambda.eq(RentContractEntity::getTenantId, tenantId);
            lambda.eq(RentContractEntity::getBillCode, rentContractVo.getBillCode());
            List<RentContractEntity> entities = super.list(lambda);
            if(entities != null && entities.size() > 0) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
        }
        entity = BeanMapper.map(rentContractVo, RentContractEntity.class);
        super.saveOrUpdate(entity,false);

        return CommonResponse.success(BeanMapper.map(entity, RentContractVO.class));
    }

    @Override
    public RentContractVO queryDetail(Long id) {
        RentContractEntity entity = rentContractMapper.selectById(id);
        if(entity != null) {
            RentContractVO rentContractVo = BeanMapper.map(entity, RentContractVO.class);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, rentContractVo.getId()));
            queryParam.getOrderMap().put("createTime", "desc");
            List<RentDetailsEntity> rentDetailss = rentDetailsService.queryList(queryParam, false);
            if(rentDetailss != null && rentDetailss.size() > 0) {
                List<RentDetailsVO> rentDetailsVos = BeanMapper.mapList(rentDetailss, RentDetailsVO.class);
                rentContractVo.setRentdetails(rentDetailsVos);
            }

            List<RentCostEntity> rentCosts = rentCostService.queryList(queryParam, false);
            if(rentCosts != null && rentCosts.size() > 0) {
                List<RentCostVO> rentCostVos = BeanMapper.mapList(rentCosts, RentCostVO.class);
                rentContractVo.setRentcost(rentCostVos);
            }

            List<RentClauseEntity> rentClauses = rentClauseService.queryList(queryParam, false);
            if(rentClauses != null && rentClauses.size() > 0) {
                List<RentClauseVO> rentClauseVos = BeanMapper.mapList(rentClauses, RentClauseVO.class);
                rentContractVo.setRentclause(rentClauseVos);
            }
            return rentContractVo;
        }
        return null;
    }

    @Override
    public void deleteRentContract(List<Long> ids) {
        for(Long id:ids) {
            rentClauseService.deleteByContractId(id);

            rentCostService.deleteByContractId(id);

            rentDetailsService.deleteByContractId(id);

            rentContractMapper.deleteById(id);
        }
    }
}