package com.ejianc.business.equipment.vo;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author sunyj
 * @String 2020/5/27  采购合同导出VO
 * @Description RentContractExportVO
 */

public class RentContractExportVO implements Serializable {

   private static final Long serialVersionUID = 2779265683203439571L;

    /**
     * 合同编码
     */
    private String billCode;

    /**
     * 合同名称
     */
    private String contractName;


    /**
     * 合同状态：1-履约, 2-中止，3-终止，4-废除，5-封账
     */
    private Integer contractStatus;

    /**
     * 项目
     */
    private Long projectId;

    /**
     * 组织
     */
    private Long orgId;

    /**
     * 经办人
     */
    private Long employeeId;

    /**
     * 总包企业名称
     */
    private Long customerId;

    /**
     * 设备供应商
     */
    private Long supplierId;

    /**
     * 签约日期
     */
    private Date signDate;

    /**
     * 合同金额(不含税)
     */
    private BigDecimal contractMny;

    /**
     * 税金
     */
    private BigDecimal taxMny;

    /**
     * 合同金额
     */
    private BigDecimal contractTaxMny;

    /**
     * 合同税率
     */
    private BigDecimal taxRate;

    /**
     * 合同支付比例
     */
    private BigDecimal payScale;

    /**
     * 采购方式(1:项目自采，0：公司集采)
     */
    private Integer rentType;

    /**
     * 备注
     */
    private String memo;

    /**
     * 单据状态（审批必须字段）
     */
    private Integer billState;


}
