/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.equipment.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.equipment.service.IApplyService;
import com.ejianc.business.equipment.vo.ApplyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"apply"})
public class ApplyController {
    @Autowired
    private IApplyService applyService;
    @Autowired
    private IOrgApi orgApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ApplyVO> saveOrUpdate(@RequestBody ApplyVO applyVo) {
        return this.applyService.saveOrUpdate(applyVo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ApplyVO> queryDetail(@RequestParam Long id) {
        ApplyVO applyVo = this.applyService.queryDetail(id);
        return CommonResponse.success((Object)applyVo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ApplyVO> vos) {
        this.applyService.deleteApply(vos);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage pageData = this.applyService.queryPage(param, false);
        JSONObject page = new JSONObject();
        page.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), ApplyVO.class));
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @GetMapping(value={"/applyRef"})
    public JSONObject applyRef(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        CommonResponse orgListResp;
        Map conditionMap;
        JSONObject jsonObject = new JSONObject();
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("projectName");
        queryParam.getFuzzyFields().add("billCode");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        Long orgId = InvocationInfoProxy.getOrgId();
        if (StringUtils.isNotBlank((CharSequence)condition) && null != (conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class)).get("orgId")) {
            orgId = Long.valueOf(conditionMap.get("orgId").toString());
        }
        if (!(orgListResp = this.orgApi.findChildrenByParentId(orgId)).isSuccess()) {
            PageImpl page = new PageImpl(new ArrayList(), (Pageable)new PageRequest(pageNumber.intValue(), pageSize.intValue()), 0L);
            jsonObject.put("data", (Object)page);
            jsonObject.put("code", (Object)"failure");
            jsonObject.put("msg", (Object)"\u67e5\u8be2\u6570\u8868\u53c2\u7167\u5931\u8d25\uff0c\u9879\u76ee\u7ec4\u7ec7\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff01");
            return jsonObject;
        }
        List orgList = (List)orgListResp.getData();
        if (CollectionUtils.isNotEmpty((Collection)orgList)) {
            orgList.stream().forEach(orgVO -> {
                if (5 == orgVO.getOrgType()) {
                    departmentIds.add(orgVO.getId());
                } else {
                    commonOrgIds.add(orgVO.getId());
                }
                if (CollectionUtils.isNotEmpty((Collection)departmentIds)) {
                    queryParam.getParams().put("orgId", new Parameter("in", (Object)commonOrgIds));
                } else if (CollectionUtils.isNotEmpty((Collection)departmentIds)) {
                    queryParam.getParams().put("projectDepartmentId", new Parameter("eq", departmentIds.get(0)));
                }
            });
        }
        IPage pageData = this.applyService.queryPage(queryParam, false);
        PageImpl page = new PageImpl(BeanMapper.mapList((Iterable)pageData.getRecords(), ApplyVO.class), (Pageable)new PageRequest(pageNumber.intValue(), pageSize.intValue()), pageData.getTotal());
        jsonObject.put("data", (Object)page);
        jsonObject.put("code", (Object)"success");
        jsonObject.put("msg", (Object)"\u67e5\u8be2\u6570\u8868\u53c2\u7167\u6210\u529f\uff01");
        return jsonObject;
    }
}

