/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.equipment.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.equipment.bean.PurchaseContractEntity;
import com.ejianc.business.equipment.mapper.PurchaseContractMapper;
import com.ejianc.business.equipment.service.IPurchaseChangeService;
import com.ejianc.business.equipment.service.IPurchaseContractService;
import com.ejianc.business.equipment.vo.PurchaseContractVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="PurchaseContractService")
public class PurchaseContractServiceImpl
extends BaseServiceImpl<PurchaseContractMapper, PurchaseContractEntity>
implements IPurchaseContractService {
    private static final String PURCHASE_CONTRACT_BILL_CODE = "EQUIPMENT_PURCHASE";
    @Autowired
    private IPurchaseChangeService purchaseChangeService;
    @Autowired
    private IBillCodeApi billCodeApi;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CommonResponse<PurchaseContractVO> saveOrUpdate(PurchaseContractVO purchaseContractVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        PurchaseContractEntity entity = null;
        Object operateType = null;
        List entities = null;
        List entitiesc = null;
        if (StringUtils.isEmpty((CharSequence)purchaseContractVo.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(PURCHASE_CONTRACT_BILL_CODE, tenantId);
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            purchaseContractVo.setBillCode((String)billCode.getData());
        } else if (purchaseContractVo.getId() != null && purchaseContractVo.getId() > 0L) {
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.eq(PurchaseContractEntity::getBillCode, (Object)purchaseContractVo.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)purchaseContractVo.getId());
            entities = super.list((Wrapper)lambda);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)purchaseContractVo.getBillCode()));
            queryParam.getParams().put("contract_id", new Parameter("ne", (Object)purchaseContractVo.getId()));
            entitiesc = this.purchaseChangeService.queryList(queryParam, false);
        } else {
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(PurchaseContractEntity::getBillCode, (Object)purchaseContractVo.getBillCode());
            entities = super.list((Wrapper)lambda);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)purchaseContractVo.getBillCode()));
            entitiesc = this.purchaseChangeService.queryList(queryParam, false);
        }
        if (entities != null && entities.size() > 0 && entitiesc != null && entitiesc.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        entity = (PurchaseContractEntity)((Object)BeanMapper.map((Object)purchaseContractVo, PurchaseContractEntity.class));
        entity.setBaseMoney(purchaseContractVo.getContractMny() == null ? BigDecimal.ZERO : purchaseContractVo.getContractMny());
        entity.setBaseTaxMoney(purchaseContractVo.getContractTaxMny() == null ? BigDecimal.ZERO : purchaseContractVo.getContractTaxMny());
        entity.setBeforeChangeMny(purchaseContractVo.getContractMny() == null ? BigDecimal.ZERO : purchaseContractVo.getContractMny());
        entity.setBeforeChangeTaxMny(purchaseContractVo.getContractTaxMny() == null ? BigDecimal.ZERO : purchaseContractVo.getContractTaxMny());
        super.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), PurchaseContractVO.class));
    }

    @Override
    public PurchaseContractVO queryDetail(Long id) {
        PurchaseContractEntity entity = (PurchaseContractEntity)((Object)super.selectById((Serializable)id));
        PurchaseContractVO purchaseContractVo = (PurchaseContractVO)BeanMapper.map((Object)((Object)entity), PurchaseContractVO.class);
        return purchaseContractVo;
    }

    @Override
    public void deletePurchaseContract(List<PurchaseContractVO> vos) {
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), false);
    }
}

